/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.util.ConcurrencyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class DocumentChangeInactivityDetector
implements DocumentListener {
    private static final int CHECK_DELAY = 500;
    private final ScheduledExecutorService myExecutorService;
    private static final Logger LOG = Logger.getInstance(DocumentChangeInactivityDetector.class);
    private volatile long myLastChangeTime;
    private volatile long myLastDocStamp;
    private final Document myDocument;
    private final List<InactivityListener> myListeners = new ArrayList<InactivityListener>();

    DocumentChangeInactivityDetector(@NotNull Document document) {
        this.myDocument = document;
        this.myExecutorService = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"DocumentChangeInactivityDetector");
    }

    void addListener(@NotNull InactivityListener listener) {
        this.myListeners.add(listener);
    }

    void removeListener(@NotNull InactivityListener listener) {
        this.myListeners.remove(listener);
    }

    void start() {
        this.myLastChangeTime = System.currentTimeMillis();
        this.myExecutorService.scheduleAtFixedRate(() -> this.checkLastUpdate(), 500L, 500L, TimeUnit.MILLISECONDS);
    }

    void stop() {
        this.myExecutorService.shutdown();
    }

    private void checkLastUpdate() {
        if (System.currentTimeMillis() - this.myLastChangeTime > 500L && this.myDocument.getModificationStamp() != this.myLastDocStamp) {
            this.myLastDocStamp = this.myDocument.getModificationStamp();
            for (InactivityListener listener : this.myListeners) {
                try {
                    listener.onInactivity();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        this.myLastChangeTime = System.currentTimeMillis();
        this.myLastDocStamp = event.getOldTimeStamp();
    }

    static interface InactivityListener {
        public void onInactivity();
    }
}

