/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.util.containers.MultiMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public class RenameGroovyScriptProcessor
extends RenamePsiFileProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        return element instanceof GroovyFile && ((GroovyFile)element).isScript() && GroovyScriptUtil.isPlainGroovyScript((GroovyFile)element);
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        String scriptName;
        PsiClass script;
        if (element instanceof GroovyFile && (script = ((GroovyFile)element).getScriptClass()) != null && script.isValid() && StringUtil.isJavaIdentifier((String)(scriptName = FileUtilRt.getNameWithoutExtension((String)newName)))) {
            allRenames.put((PsiElement)script, scriptName);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        String scriptName = FileUtilRt.getNameWithoutExtension((String)newName);
        if (!StringUtil.isJavaIdentifier((String)scriptName)) {
            PsiClass script = ((GroovyFile)element).getScriptClass();
            conflicts.putValue((Object)script, (Object)GroovyRefactoringBundle.message("cannot.rename.script.class.to.0", script.getName(), scriptName));
        }
    }
}

