/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureViewDescriptor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeInfoImpl;

public class GrChangeSignatureProcessor
extends ChangeSignatureProcessorBase {
    public static final Logger LOG = Logger.getInstance(GrChangeSignatureProcessor.class);

    public GrChangeSignatureProcessor(Project project, GrChangeInfoImpl changeInfo) {
        super(project, (ChangeInfo)changeInfo);
    }

    public GrChangeInfoImpl getChangeInfo() {
        return (GrChangeInfoImpl)super.getChangeInfo();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        return new ChangeSignatureViewDescriptor((PsiMethod)this.getChangeInfo().getMethod());
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        boolean condition = elements.length == 1 && elements[0] instanceof PsiMethod;
        LOG.assertTrue(condition);
        this.getChangeInfo().updateMethod((PsiMethod)elements[0]);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        MultiMap conflictDescriptions = new MultiMap();
        GrChangeSignatureProcessor.collectConflictsFromExtensions(refUsages, (MultiMap)conflictDescriptions, (ChangeInfo)this.myChangeInfo);
        Object[] usagesIn = (UsageInfo[])refUsages.get();
        RenameUtil.addConflictDescriptions((UsageInfo[])usagesIn, (MultiMap)conflictDescriptions);
        Set usagesSet = ContainerUtil.set((Object[])usagesIn);
        RenameUtil.removeConflictUsages((Set)usagesSet);
        if (!conflictDescriptions.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflictDescriptions.values());
            }
            ConflictsDialog dialog = this.prepareConflictsDialog(conflictDescriptions, (UsageInfo[])usagesIn);
            if (!dialog.showAndGet()) {
                if (dialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        refUsages.set((Object)usagesSet.toArray(UsageInfo.EMPTY_ARRAY));
        this.prepareSuccessful();
        return true;
    }
}

