/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.application.PathMacroContributor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class MvcPathMacros
implements PathMacroContributor {
    public void registerPathMacros(@NotNull Map<String, String> macros, @NotNull Map<String, String> legacyMacros) {
        Set<String> macroNames = macros.keySet();
        for (String framework : (String[])ContainerUtil.ar((Object[])new String[]{"grails", "griffon"})) {
            String name = "USER_HOME_" + StringUtil.toUpperCase((String)framework);
            if (macroNames.contains(name)) continue;
            legacyMacros.put(name, StringUtil.trimEnd((String)MvcPathMacros.getSdkWorkDirParent(framework), (String)"/"));
        }
    }

    @NotNull
    public static String getSdkWorkDirParent(String framework) {
        String grailsWorkDir = System.getProperty(framework + ".work.dir");
        if (StringUtil.isNotEmpty((String)grailsWorkDir)) {
            if (!(grailsWorkDir = FileUtil.toSystemIndependentName((String)grailsWorkDir)).endsWith("/")) {
                grailsWorkDir = grailsWorkDir + "/";
            }
            return grailsWorkDir;
        }
        return StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome()), (String)"/") + "/." + framework + "/";
    }
}

