/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderAnnotationContributor;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class SimpleBuilderStrategySupport
extends BuilderAnnotationContributor {
    public static final String SIMPLE_STRATEGY_NAME = "SimpleStrategy";

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        GrTypeDefinition typeDefinition = context.getCodeClass();
        PsiAnnotation annotation = PsiImplUtil.getAnnotation((PsiModifierListOwner)typeDefinition, "groovy.transform.builder.Builder");
        if (!SimpleBuilderStrategySupport.isApplicable(annotation, SIMPLE_STRATEGY_NAME)) {
            return;
        }
        if (SimpleBuilderStrategySupport.isIncludeSuperProperties(annotation)) {
            return;
        }
        for (GrField field : typeDefinition.getCodeFields()) {
            context.addMethod((PsiMethod)SimpleBuilderStrategySupport.createFieldSetter(typeDefinition, field, annotation));
        }
    }

    @NotNull
    public static LightMethodBuilder createFieldSetter(@NotNull PsiClass builderClass, @NotNull GrVariable field, @NotNull PsiAnnotation annotation) {
        String name = field.getName();
        LightMethodBuilder fieldSetter = new LightMethodBuilder(builderClass.getManager(), SimpleBuilderStrategySupport.getFieldMethodName(annotation, name));
        fieldSetter.addModifier("public");
        fieldSetter.addParameter(name, field.getType(), false);
        fieldSetter.setMethodReturnType((PsiType)TypesUtil.createType(builderClass));
        fieldSetter.setNavigationElement((PsiElement)field);
        fieldSetter.setOriginInfo("via @Builder");
        return fieldSetter;
    }

    @NotNull
    public static String getFieldMethodName(@NotNull PsiAnnotation annotation, @NotNull String fieldName) {
        String prefix = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"prefix");
        return prefix == null ? "set" + StringUtil.capitalize((String)fieldName) : (prefix.isEmpty() ? fieldName : prefix + StringUtil.capitalize((String)fieldName));
    }
}

