/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionMembersCache;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.code.FileCodeMembersProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightTypeDefinitionBase;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

public final class GroovyScriptClass
extends GrLightTypeDefinitionBase
implements SyntheticElement {
    private final GroovyFile myFile;
    private final GrTypeDefinitionMembersCache<GroovyScriptClass> myCache;

    public GroovyScriptClass(@NotNull GroovyFile file) {
        super(file);
        this.myFile = file;
        this.myCache = new GrTypeDefinitionMembersCache<GroovyScriptClass>(this, FileCodeMembersProvider.INSTANCE);
        this.getModifierList().addModifier(1);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitClass((PsiClass)this);
        }
    }

    public PsiElement copy() {
        return new GroovyScriptClass(this.myFile);
    }

    @NotNull
    public GroovyFile getContainingFile() {
        return this.myFile;
    }

    public TextRange getTextRange() {
        return this.myFile.getTextRange();
    }

    public int getTextOffset() {
        return 0;
    }

    public boolean isValid() {
        return this.myFile.isValid() && this.myFile.isScript();
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        return StringUtil.getQualifiedName((String)this.myFile.getPackageName(), (String)this.getName());
    }

    public boolean isWritable() {
        return this.myFile.isWritable();
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        return this.myFile.add(element);
    }

    public PsiElement addAfter(@NotNull PsiElement element, @Nullable PsiElement anchor) throws IncorrectOperationException {
        return this.myFile.addAfter(element, anchor);
    }

    public PsiElement addBefore(@NotNull PsiElement element, @Nullable PsiElement anchor) throws IncorrectOperationException {
        return this.myFile.addBefore(element, anchor);
    }

    @Override
    public PsiClassType @NotNull [] getExtendsListTypes(boolean includeSynthetic) {
        return this.myCache.getExtendsListTypes(includeSynthetic);
    }

    @Override
    public PsiClassType @NotNull [] getImplementsListTypes(boolean includeSynthetic) {
        return this.myCache.getImplementsListTypes(includeSynthetic);
    }

    @Override
    public GrField @NotNull [] getFields() {
        return this.myCache.getFields();
    }

    public PsiMethod @NotNull [] getMethods() {
        return this.myCache.getMethods();
    }

    public PsiMethod @NotNull [] getConstructors() {
        return this.myCache.getConstructors();
    }

    public PsiClass @NotNull [] getInnerClasses() {
        return this.myCache.getInnerClasses();
    }

    @Override
    public GrField @NotNull [] getCodeFields() {
        return GrField.EMPTY_ARRAY;
    }

    @Override
    public GrMethod @NotNull [] getCodeConstructors() {
        return GrMethod.EMPTY_ARRAY;
    }

    @Override
    public GrMethod @NotNull [] getCodeMethods() {
        return this.myCache.getCodeMethods();
    }

    @Override
    public PsiElement getScope() {
        return this.myFile;
    }

    @Override
    @NotNull
    public String getName() {
        return FileUtilRt.getNameWithoutExtension((String)this.myFile.getName());
    }

    @Override
    public PsiElement setName(@NotNull @NonNls String name) throws IncorrectOperationException {
        this.myFile.setName(PathUtil.makeFileName((String)name, (String)this.myFile.getViewProvider().getVirtualFile().getExtension()));
        return this;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (ResolveUtilKt.shouldProcessMethods(processor) || ResolveUtilKt.shouldProcessProperties(processor)) {
            return GrClassImplUtil.processDeclarations(this, processor, state, lastParent, place);
        }
        return true;
    }

    public PsiElement getContext() {
        return this.myFile;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return GroovyScriptClass.this.getName();
            }

            public String getLocationString() {
                String packageName = GroovyScriptClass.this.myFile.getPackageName();
                return "(groovy script" + (packageName.isEmpty() ? "" : ", " + packageName) + ")";
            }

            public Icon getIcon(boolean open) {
                return GroovyScriptClass.this.getIcon(3);
            }
        };
    }

    public PsiElement getOriginalElement() {
        return JavaPsiImplementationHelper.getInstance((Project)this.getProject()).getOriginalClass((PsiClass)this);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public Icon getIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, JetgroovyIcons.Groovy.Class, 0);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, (int)flags, (RowIcon)baseIcon);
    }

    public void checkDelete() throws IncorrectOperationException {
    }

    public void delete() throws IncorrectOperationException {
        this.myFile.delete();
    }
}

