/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityIcons;
import icons.JetgroovyIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleSettingsFacade;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionMembersCache;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyRunnerPsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrTypeDefinitionImpl
extends GrStubElementBase<GrTypeDefinitionStub>
implements GrTypeDefinition,
StubBasedPsiElement<GrTypeDefinitionStub> {
    private final GrTypeDefinitionMembersCache<GrTypeDefinition> myCache = new GrTypeDefinitionMembersCache<GrTypeDefinitionImpl>(this);

    public GrTypeDefinitionImpl(@NotNull ASTNode node) {
        super(node);
    }

    protected GrTypeDefinitionImpl(GrTypeDefinitionStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitTypeDefinition(this);
    }

    public int getTextOffset() {
        return this.getNameIdentifierGroovy().getTextRange().getStartOffset();
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GroovyFile) {
            String packageName = ((GroovyFile)parent2).getPackageName();
            return !packageName.isEmpty() ? packageName + "." + this.getName() : this.getName();
        }
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null && containingClass.getQualifiedName() != null) {
            return containingClass.getQualifiedName() + "." + this.getName();
        }
        return null;
    }

    @Override
    @Nullable
    public GrTypeDefinitionBody getBody() {
        return (GrTypeDefinitionBody)this.getStubOrPsiChild((IStubElementType)GroovyEmptyStubElementTypes.CLASS_BODY);
    }

    @Override
    public GrMembersDeclaration @NotNull [] getMemberDeclarations() {
        GrTypeDefinitionBody body = this.getBody();
        if (body == null) {
            return GrMembersDeclaration.EMPTY_ARRAY;
        }
        return body.getMemberDeclarations();
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    @Nullable
    public GrExtendsClause getExtendsClause() {
        return (GrExtendsClause)this.getStubOrPsiChild(GroovyStubElementTypes.EXTENDS_CLAUSE);
    }

    @Override
    @Nullable
    public GrImplementsClause getImplementsClause() {
        return (GrImplementsClause)this.getStubOrPsiChild(GroovyStubElementTypes.IMPLEMENTS_CLAUSE);
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement result2 = this.findChildByType(TokenSets.PROPERTY_NAMES);
        assert (result2 != null);
        return result2;
    }

    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        GroovyFileImpl file;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GroovyFileImpl && (file = (GroovyFileImpl)parent2).getTypeDefinitions().length == 1 && !file.isScript()) {
            file.delete();
            return;
        }
        super.delete();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        return GrClassImplUtil.processDeclarations(this, processor, state, lastParent, place);
    }

    @Override
    public String getName() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        return PsiImplUtil.getName(this);
    }

    public boolean isEquivalentTo(PsiElement another) {
        return GrClassImplUtil.isClassEquivalentTo(this, another);
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isTrait() {
        return false;
    }

    @Nullable
    public PsiReferenceList getExtendsList() {
        return this.getExtendsClause();
    }

    @Nullable
    public PsiReferenceList getImplementsList() {
        return this.getImplementsClause();
    }

    @Override
    public PsiClassType @NotNull [] getExtendsListTypes(boolean includeSynthetic) {
        return this.myCache.getExtendsListTypes(includeSynthetic);
    }

    @Override
    public PsiClassType @NotNull [] getImplementsListTypes(boolean includeSynthetic) {
        return this.myCache.getImplementsListTypes(includeSynthetic);
    }

    @Nullable
    public PsiClass getSuperClass() {
        return GrClassImplUtil.getSuperClass(this);
    }

    public PsiClass @NotNull [] getInterfaces() {
        return GrClassImplUtil.getInterfaces(this);
    }

    @Override
    public final PsiClass @NotNull [] getSupers(boolean includeSynthetic) {
        return GrClassImplUtil.getSupers(this, includeSynthetic);
    }

    @Override
    public PsiClassType @NotNull [] getSuperTypes(boolean includeSynthetic) {
        return GrClassImplUtil.getSuperTypes(this, includeSynthetic);
    }

    @Override
    public GrField @NotNull [] getCodeFields() {
        return this.myCache.getCodeFields();
    }

    @Override
    public PsiField findCodeFieldByName(String name, boolean checkBases) {
        return GrClassImplUtil.findFieldByName(this, name, checkBases, false);
    }

    @Override
    public GrField @NotNull [] getFields() {
        return this.myCache.getFields();
    }

    public PsiMethod @NotNull [] getMethods() {
        return this.myCache.getMethods();
    }

    @Override
    public GrMethod @NotNull [] getCodeMethods() {
        return this.myCache.getCodeMethods();
    }

    public PsiMethod @NotNull [] getConstructors() {
        return this.myCache.getConstructors();
    }

    @Override
    public GrMethod @NotNull [] getCodeConstructors() {
        return this.myCache.getCodeConstructors();
    }

    public PsiClass @NotNull [] getInnerClasses() {
        return this.myCache.getInnerClasses();
    }

    @Override
    public GrTypeDefinition @NotNull [] getCodeInnerClasses() {
        return this.myCache.getCodeInnerClasses();
    }

    @Override
    public GrClassInitializer @NotNull [] getInitializers() {
        GrTypeDefinitionBody body = this.getBody();
        return body != null ? body.getInitializers() : GrClassInitializer.EMPTY_ARRAY;
    }

    public PsiField @NotNull [] getAllFields() {
        return GrClassImplUtil.getAllFields(this);
    }

    public PsiMethod @NotNull [] getAllMethods() {
        return GrClassImplUtil.getAllMethods(this);
    }

    public PsiClass @NotNull [] getAllInnerClasses() {
        return PsiClassImplUtil.getAllInnerClasses((PsiClass)this);
    }

    @Nullable
    public PsiField findFieldByName(String name, boolean checkBases) {
        return GrClassImplUtil.findFieldByName(this, name, checkBases, true);
    }

    @Nullable
    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return GrClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    public PsiMethod @NotNull [] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        return GrClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
    }

    @Override
    public PsiMethod @NotNull [] findCodeMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        return GrClassImplUtil.findCodeMethodsBySignature(this, patternMethod, checkBases);
    }

    public PsiMethod @NotNull [] findMethodsByName(@NonNls String name, boolean checkBases) {
        return GrClassImplUtil.findMethodsByName(this, name, checkBases);
    }

    @Override
    public PsiMethod @NotNull [] findCodeMethodsByName(@NonNls String name, boolean checkBases) {
        return GrClassImplUtil.findCodeMethodsByName(this, name, checkBases);
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name, boolean checkBases) {
        return GrClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name, checkBases);
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        return GrClassImplUtil.getAllMethodsAndTheirSubstitutors(this);
    }

    @Nullable
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return GrClassImplUtil.findInnerClassByName(this, name, checkBases);
    }

    @Nullable
    public PsiElement getLBrace() {
        GrTypeDefinitionBody body = this.getBody();
        return body == null ? null : body.getLBrace();
    }

    @Nullable
    public PsiElement getRBrace() {
        GrTypeDefinitionBody body = this.getBody();
        return body == null ? null : body.getRBrace();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return PsiUtil.getJavaNameIdentifier(this);
    }

    @Nullable
    public PsiElement getScope() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        ASTNode treeElement = this.getNode();
        for (ASTNode parent2 = treeElement.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            if (!(parent2.getElementType() instanceof IStubElementType) || parent2.getElementType() == GroovyEmptyStubElementTypes.CLASS_BODY) continue;
            return parent2.getPsi();
        }
        return this.getContainingFile();
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (this.isTrait() && baseClass.isInterface() && !checkDeep) {
            for (PsiClassType superType : this.getImplementsListTypes()) {
                if (!this.getManager().areElementsEquivalent((PsiElement)superType.resolve(), (PsiElement)baseClass)) continue;
                return true;
            }
        }
        return InheritanceImplUtil.isInheritor((PsiClass)this, (PsiClass)baseClass, (boolean)checkDeep);
    }

    public boolean isInheritorDeep(PsiClass baseClass, @Nullable PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep((PsiClass)this, (PsiClass)baseClass, (PsiClass)classToByPass);
    }

    @Nullable
    public PsiClass getContainingClass() {
        PsiElement pparent;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GrTypeDefinitionBody && (pparent = parent2.getParent()) instanceof PsiClass) {
            return (PsiClass)pparent;
        }
        return null;
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        return PsiSuperMethodImplUtil.getVisibleSignatures((PsiClass)this);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        boolean renameFile = this.isRenameFileOnClassRenaming();
        String oldName = this.getName();
        PsiImplUtil.setName(name, this.getNameIdentifierGroovy());
        GrTypeDefinitionBody body = this.getBody();
        if (body != null) {
            for (GrMethod method : body.getMethods()) {
                if (!method.isConstructor() || !method.getName().equals(oldName)) continue;
                method.setName(name);
            }
        }
        if (renameFile) {
            PsiFile file = this.getContainingFile();
            VirtualFile virtualFile = file.getVirtualFile();
            String ext = virtualFile != null ? virtualFile.getExtension() : GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension();
            file.setName(name + "." + ext);
        }
        return this;
    }

    @Override
    @Nullable
    public GrModifierList getModifierList() {
        return (GrModifierList)this.getStubOrPsiChild(GroovyStubElementTypes.MODIFIER_LIST);
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        GrModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(name);
    }

    @Override
    @Nullable
    public GrDocComment getDocComment() {
        return GrDocCommentUtil.findDocComment(this);
    }

    @Override
    public boolean isDeprecated() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecatedByDoc() || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
        }
        return com.intellij.psi.impl.PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)this) || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public boolean hasTypeParameters() {
        return this.getTypeParameters().length > 0;
    }

    @Override
    @Nullable
    public GrTypeParameterList getTypeParameterList() {
        return (GrTypeParameterList)this.getStubOrPsiChild((IStubElementType)GroovyEmptyStubElementTypes.TYPE_PARAMETER_LIST);
    }

    public GrTypeParameter @NotNull [] getTypeParameters() {
        GrTypeParameterList list = this.getTypeParameterList();
        if (list != null) {
            return list.getTypeParameters();
        }
        return GrTypeParameter.EMPTY_ARRAY;
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.getIconInner();
        boolean isLocked = (flags & 2) != 0 && !this.isWritable();
        RowIcon rowIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, icon, ElementPresentationUtil.getFlags((PsiModifierListOwner)this, (boolean)isLocked) | this.getFlagsInner());
        if ((flags & 1) != 0) {
            VisibilityIcons.setVisibilityIcon((PsiModifierList)this.getModifierList(), (RowIcon)rowIcon);
        }
        return rowIcon;
    }

    private int getFlagsInner() {
        return !DumbService.isDumb((Project)this.getProject()) && GroovyRunnerPsiUtil.isRunnable(this) ? 16384 : 0;
    }

    private Icon getIconInner() {
        if (this.isAnnotationType()) {
            return JetgroovyIcons.Groovy.AnnotationType;
        }
        if (this.isTrait()) {
            return JetgroovyIcons.Groovy.Trait;
        }
        if (this.isInterface()) {
            return JetgroovyIcons.Groovy.Interface;
        }
        if (this.isEnum()) {
            return JetgroovyIcons.Groovy.Enum;
        }
        if (this.hasModifierProperty("abstract")) {
            return JetgroovyIcons.Groovy.AbstractClass;
        }
        return JetgroovyIcons.Groovy.Class;
    }

    private boolean isRenameFileOnClassRenaming() {
        PsiFile file = this.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        GroovyFile groovyFile = (GroovyFile)file;
        if (groovyFile.isScript()) {
            return false;
        }
        String name = this.getName();
        VirtualFile vFile = groovyFile.getVirtualFile();
        return vFile != null && name != null && name.equals(vFile.getNameWithoutExtension());
    }

    @Nullable
    public PsiElement getOriginalElement() {
        return JavaPsiImplementationHelper.getInstance((Project)this.getProject()).getOriginalClass((PsiClass)this);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            return this.add(element);
        }
        GrTypeDefinitionBody body = this.getBody();
        if (anchor.getParent() == body) {
            PsiElement nextChild = anchor.getNextSibling();
            if (nextChild == null) {
                return this.add(element);
            }
            if (body == null) {
                throw new IncorrectOperationException("Class must have body");
            }
            return body.addBefore(element, nextChild);
        }
        return super.addAfter(element, anchor);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            return this.add(element);
        }
        GrTypeDefinitionBody body = this.getBody();
        if (anchor.getParent() != body) {
            return super.addBefore(element, anchor);
        }
        if (body == null) {
            throw new IncorrectOperationException("Class must have body");
        }
        return body.addBefore(element, anchor);
    }

    public PsiElement add(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        PsiElement anchor;
        GrTypeDefinitionBody body = this.getBody();
        if (body == null) {
            throw new IncorrectOperationException("Class must have body");
        }
        PsiElement lBrace = body.getLBrace();
        if (lBrace == null) {
            throw new IncorrectOperationException("No left brace");
        }
        PsiMember member = GrTypeDefinitionImpl.getAnyMember(psiElement);
        PsiElement psiElement2 = anchor = member != null ? this.getDefaultAnchor(body, member) : null;
        if (anchor == null) {
            anchor = lBrace.getNextSibling();
        }
        if (anchor != null) {
            ASTNode node = anchor.getNode();
            assert (node != null);
            if (GroovyTokenTypes.mSEMI.equals(node.getElementType())) {
                anchor = anchor.getNextSibling();
            }
            if (psiElement instanceof GrField) {
                int i = ArrayUtilRt.find((Object[])((GrVariableDeclaration)psiElement.getParent()).getVariables(), (Object)psiElement);
                psiElement = body.addBefore(psiElement.getParent(), anchor);
                GrVariable[] vars = ((GrVariableDeclaration)psiElement).getVariables();
                for (int j = 0; j < vars.length; ++j) {
                    if (i == j) continue;
                    vars[i].delete();
                }
                psiElement = vars[i];
            } else {
                psiElement = body.addBefore(psiElement, anchor);
            }
        } else {
            psiElement = body.add(psiElement);
        }
        return psiElement;
    }

    @Nullable
    protected static PsiMember getAnyMember(@Nullable PsiElement psiElement) {
        GrMember[] members;
        if (psiElement instanceof PsiMember) {
            return (PsiMember)psiElement;
        }
        if (psiElement instanceof GrVariableDeclaration && (members = ((GrVariableDeclaration)psiElement).getMembers()).length > 0) {
            return members[0];
        }
        return null;
    }

    public static int getMemberOrderWeight(PsiElement member, GroovyCodeStyleSettingsFacade settings) {
        if (member instanceof PsiField) {
            if (member instanceof PsiEnumConstant) {
                return 1;
            }
            return ((PsiField)member).hasModifierProperty("static") ? settings.staticFieldsOrderWeight() + 1 : settings.fieldsOrderWeight() + 1;
        }
        if (member instanceof PsiMethod) {
            if (((PsiMethod)member).isConstructor()) {
                return settings.constructorsOrderWeight() + 1;
            }
            return ((PsiMethod)member).hasModifierProperty("static") ? settings.staticMethodsOrderWeight() + 1 : settings.methodsOrderWeight() + 1;
        }
        if (member instanceof PsiClass) {
            return ((PsiClass)member).hasModifierProperty("static") ? settings.staticInnerClassesOrderWeight() + 1 : settings.innerClassesOrderWeight() + 1;
        }
        return -1;
    }

    @Nullable
    protected PsiElement getDefaultAnchor(GrTypeDefinitionBody body, PsiMember member) {
        GroovyCodeStyleSettingsFacade settings = GroovyCodeStyleSettingsFacade.getInstance(this.getProject());
        int order = GrTypeDefinitionImpl.getMemberOrderWeight((PsiElement)member, settings);
        if (order < 0) {
            return null;
        }
        PsiElement lastMember = null;
        for (PsiElement child = body.getFirstChild(); child != null; child = child.getNextSibling()) {
            int order1 = GrTypeDefinitionImpl.getMemberOrderWeight((PsiElement)GrTypeDefinitionImpl.getAnyMember(child), settings);
            if (order1 < 0) continue;
            if (order1 > order) {
                PsiElement lBrace = body.getLBrace();
                if (lastMember != null) {
                    PsiElement nextSibling = lastMember.getNextSibling();
                    while (nextSibling instanceof LeafPsiElement && (nextSibling.getText().equals(",") || nextSibling.getText().equals(";"))) {
                        nextSibling = nextSibling.getNextSibling();
                    }
                    return nextSibling == null && lBrace != null ? PsiUtil.skipWhitespacesAndComments(lBrace.getNextSibling(), true) : nextSibling;
                }
                if (lBrace != null) {
                    return PsiUtil.skipWhitespacesAndComments(lBrace.getNextSibling(), true);
                }
            }
            lastMember = child;
        }
        return body.getRBrace();
    }
}

