/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.EmptyStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public abstract class GrTypeDefinitionBodyBase
extends GrStubElementBase<EmptyStub>
implements GrTypeDefinitionBody {
    public GrTypeDefinitionBodyBase(@NotNull ASTNode node) {
        super(node);
    }

    public GrTypeDefinitionBodyBase(EmptyStub stub, IStubElementType classBody) {
        super(stub, classBody);
    }

    @Override
    public abstract void accept(@NotNull GroovyElementVisitor var1);

    public String toString() {
        return "Type definition body";
    }

    @Override
    public GrField @NotNull [] getFields() {
        GrVariableDeclaration[] declarations = (GrVariableDeclaration[])this.getStubOrPsiChildren(GroovyStubElementTypes.VARIABLE_DECLARATION, GrVariableDeclaration.ARRAY_FACTORY);
        ArrayList<GrField> result2 = new ArrayList<GrField>();
        for (GrVariableDeclaration declaration : declarations) {
            GrVariable[] variables;
            for (GrVariable variable : variables = declaration.getVariables()) {
                if (!(variable instanceof GrField)) continue;
                result2.add((GrField)variable);
            }
        }
        return result2.toArray(GrField.EMPTY_ARRAY);
    }

    @Override
    public GrMethod @NotNull [] getMethods() {
        return (GrMethod[])this.getStubOrPsiChildren(TokenSets.METHOD_DEFS, GrMethod.ARRAY_FACTORY);
    }

    @Override
    public GrMembersDeclaration @NotNull [] getMemberDeclarations() {
        return (GrMembersDeclaration[])this.findChildrenByClass(GrMembersDeclaration.class);
    }

    @Override
    @Nullable
    public PsiElement getLBrace() {
        return this.findChildByType(GroovyTokenTypes.mLCURLY);
    }

    @Override
    @Nullable
    public PsiElement getRBrace() {
        return this.findChildByType(GroovyTokenTypes.mRCURLY);
    }

    @Override
    public GrClassInitializer @NotNull [] getInitializers() {
        return (GrClassInitializer[])this.findChildrenByClass(GrClassInitializer.class);
    }

    @Override
    public GrTypeDefinition @NotNull [] getInnerClasses() {
        return (GrTypeDefinition[])this.getStubOrPsiChildren(TokenSets.TYPE_DEFINITIONS, GrTypeDefinition.ARRAY_FACTORY);
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        PsiElement rBrace = this.getRBrace();
        if (anchor == null && rBrace == null) {
            throw new IncorrectOperationException();
        }
        if (anchor != null && !this.equals(anchor.getParent())) {
            throw new IncorrectOperationException();
        }
        ASTNode elemNode = declaration.getNode();
        ASTNode anchorNode = anchor != null ? anchor.getNode() : rBrace.getNode();
        this.getNode().addChild(elemNode, anchorNode);
        this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchorNode);
        return (GrVariableDeclaration)elemNode.getPsi();
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement element = child.getPsi();
        if (element instanceof GrTopStatement) {
            PsiImplUtil.deleteStatementTail(this, element);
        }
        super.deleteChildInternal(child);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        if (last instanceof GrTopStatement) {
            PsiImplUtil.deleteStatementTail(this, last);
        }
        super.deleteChildRange(first, last);
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        ASTNode afterLast = last.getTreeNext();
        ASTNode child = first;
        while (child != afterLast) {
            ASTNode next = child.getTreeNext();
            if (child.getElementType() == GroovyStubElementTypes.CONSTRUCTOR) {
                ASTNode oldIdentifier = child.findChildByType(GroovyTokenTypes.mIDENT);
                ASTNode newIdentifier = ((GrTypeDefinition)this.getParent()).getNameIdentifierGroovy().getNode().copyElement();
                child.replaceChild(oldIdentifier, newIdentifier);
            }
            child = next;
        }
        return super.addInternal(first, last, anchor, before);
    }

    public static class GrEnumBody
    extends GrTypeDefinitionBodyBase
    implements GrEnumDefinitionBody,
    StubBasedPsiElement<EmptyStub> {
        public GrEnumBody(@NotNull ASTNode node) {
            super(node);
        }

        public GrEnumBody(EmptyStub stub) {
            super(stub, (IStubElementType)GroovyEmptyStubElementTypes.ENUM_BODY);
        }

        @Override
        @Nullable
        public GrEnumConstantList getEnumConstantList() {
            return (GrEnumConstantList)this.getStubOrPsiChild((IStubElementType)GroovyEmptyStubElementTypes.ENUM_CONSTANTS);
        }

        @Override
        public GrEnumConstant @NotNull [] getEnumConstants() {
            GrEnumConstantList list = this.getEnumConstantList();
            if (list != null) {
                return list.getEnumConstants();
            }
            return GrEnumConstant.EMPTY_ARRAY;
        }

        @Override
        public GrField @NotNull [] getFields() {
            Object[] bodyFields = super.getFields();
            Object[] enumConstants = this.getEnumConstants();
            if (bodyFields.length == 0) {
                return enumConstants;
            }
            if (enumConstants.length == 0) {
                return bodyFields;
            }
            return (GrField[])ArrayUtil.mergeArrays((Object[])bodyFields, (Object[])enumConstants);
        }

        @Override
        public void accept(@NotNull GroovyElementVisitor visitor2) {
            visitor2.visitEnumDefinitionBody(this);
        }
    }

    public static class GrClassBody
    extends GrTypeDefinitionBodyBase
    implements StubBasedPsiElement<EmptyStub> {
        public GrClassBody(@NotNull ASTNode node) {
            super(node);
        }

        public GrClassBody(EmptyStub stub) {
            super(stub, (IStubElementType)GroovyEmptyStubElementTypes.CLASS_BODY);
        }

        @Override
        public void accept(@NotNull GroovyElementVisitor visitor2) {
            visitor2.visitTypeDefinitionBody(this);
        }
    }
}

