/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrOperatorExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrOperatorReference;
import org.jetbrains.plugins.groovy.util.SafePublicationClearableLazyValue;

public class GrAssignmentExpressionImpl
extends GrOperatorExpressionImpl
implements GrAssignmentExpression {
    private final SafePublicationClearableLazyValue<GroovyCallReference> myReference = new SafePublicationClearableLazyValue(() -> this.isOperatorAssignment() ? new GrOperatorReference(this) : null);
    private final Function<GrAssignmentExpression, PsiType> ELVIS_TYPE_CALCULATOR = e -> TypesUtil.getLeastUpperBoundNullable(e.getLeftType(), e.getRightType(), e.getManager());

    public GrAssignmentExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public GroovyCallReference getReference() {
        return this.myReference.getValue();
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myReference.clear();
    }

    public String toString() {
        return "Assignment expression";
    }

    @Override
    @NotNull
    public GrExpression getLValue() {
        return Objects.requireNonNull(GrAssignmentExpressionImpl.findExpressionChild(this));
    }

    @Override
    @Nullable
    public GrExpression getRValue() {
        GrExpression[] exprs = (GrExpression[])this.findChildrenByClass(GrExpression.class);
        if (exprs.length > 1) {
            return exprs[1];
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement getOperationToken() {
        return this.findNotNullChildByType(GroovyTokenSets.ASSIGNMENTS);
    }

    @Override
    @Nullable
    public IElementType getOperator() {
        return TokenSets.ASSIGNMENTS_TO_OPERATORS.get(this.getOperationTokenType());
    }

    @Override
    public boolean isOperatorAssignment() {
        return TokenSets.ASSIGNMENTS_TO_OPERATORS.containsKey(this.getOperationTokenType());
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitAssignmentExpression(this);
    }

    @Override
    @Nullable
    public PsiType getLeftType() {
        return this.getLValue().getType();
    }

    @Override
    @Nullable
    public PsiType getRightType() {
        GrExpression rValue = this.getRValue();
        return rValue == null ? null : rValue.getType();
    }

    @Override
    @Nullable
    public PsiType getType() {
        IElementType type2 = this.getOperationTokenType();
        if (TokenSets.ASSIGNMENTS_TO_OPERATORS.containsKey(type2)) {
            return super.getType();
        }
        if (type2 == GroovyElementTypes.T_ELVIS_ASSIGN) {
            return TypeInferenceHelper.getCurrentContext().getExpressionType(this, this.ELVIS_TYPE_CALCULATOR);
        }
        return this.getRightType();
    }
}

