/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;

public final class GrAnnotationCollector {
    public static GrAnnotation @NotNull [] getResolvedAnnotations(@NotNull GrModifierList modifierList) {
        GrAnnotation[] rawAnnotations = modifierList.getRawAnnotations();
        if (!GrAnnotationCollector.mayHaveAnnotationCollector(rawAnnotations)) {
            return rawAnnotations;
        }
        ArrayList<GrAnnotation> result2 = new ArrayList<GrAnnotation>();
        for (GrAnnotation annotation : rawAnnotations) {
            PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
            if (annotationCollector != null) {
                if (GrAnnotationCollector.collectCompileDynamic(result2, annotation)) continue;
                GrAnnotationCollector.collectAnnotations(result2, annotation, annotationCollector);
                continue;
            }
            if (GrAnnotationCollector.collectHardcoded(result2, annotation)) continue;
            result2.add(annotation);
        }
        return result2.toArray(GrAnnotation.EMPTY_ARRAY);
    }

    @NotNull
    public static Set<String> collectAnnotations(@NotNull List<? super GrAnnotation> list, @NotNull GrAnnotation alias, @NotNull PsiAnnotation annotationCollector) {
        PsiModifierList modifierList = (PsiModifierList)annotationCollector.getParent();
        LinkedHashMap<String, Map<String, PsiNameValuePair>> annotations2 = new LinkedHashMap<String, Map<String, PsiNameValuePair>>();
        GrAnnotationCollector.collectAliasedAnnotationsFromAnnotationCollectorValueAttribute(annotationCollector, annotations2);
        GrAnnotationCollector.collectAliasedAnnotationsFromAnnotationCollectorAnnotations(modifierList, annotations2);
        PsiManager manager = alias.getManager();
        GrAnnotationNameValuePair[] attributes = alias.getParameterList().getAttributes();
        LinkedHashSet<String> allUsedAttrs = new LinkedHashSet<String>();
        for (Map.Entry entry : annotations2.entrySet()) {
            PsiClass resolved;
            String qname = (String)entry.getKey();
            if (qname.equals(alias.getQualifiedName()) || (resolved = JavaPsiFacade.getInstance((Project)alias.getProject()).findClass(qname, alias.getResolveScope())) == null) continue;
            GrLightAnnotation annotation = new GrLightAnnotation(manager, alias.getLanguage(), qname, modifierList);
            LinkedHashSet<String> usedAttrs = new LinkedHashSet<String>();
            for (GrAnnotationNameValuePair attr : attributes) {
                String name;
                String string = name = attr.getName() != null ? attr.getName() : "value";
                if (resolved.findMethodsByName(name, false).length <= 0) continue;
                annotation.addAttribute(attr);
                allUsedAttrs.add(name);
                usedAttrs.add(name);
            }
            Map defaults = (Map)entry.getValue();
            for (Map.Entry defa : defaults.entrySet()) {
                if (usedAttrs.contains(defa.getKey())) continue;
                annotation.addAttribute((PsiNameValuePair)defa.getValue());
            }
            list.add(annotation);
        }
        return allUsedAttrs;
    }

    private static void collectAliasedAnnotationsFromAnnotationCollectorAnnotations(@NotNull PsiModifierList modifierList, @NotNull Map<String, Map<String, PsiNameValuePair>> annotations2) {
        PsiAnnotation[] rawAnnotations;
        for (PsiAnnotation annotation : rawAnnotations = modifierList instanceof GrModifierList ? ((GrModifierList)modifierList).getRawAnnotations() : modifierList.getAnnotations()) {
            PsiNameValuePair[] attributes;
            String qname = annotation.getQualifiedName();
            if (qname == null || qname.equals("groovy.transform.AnnotationCollector") || qname.startsWith("java.lang.annotation")) continue;
            for (PsiNameValuePair pair : attributes = annotation.getParameterList().getAttributes()) {
                Map<String, PsiNameValuePair> map2 = annotations2.get(qname);
                if (map2 == null) {
                    map2 = new LinkedHashMap<String, PsiNameValuePair>();
                    annotations2.put(qname, map2);
                }
                map2.put(pair.getName() != null ? pair.getName() : "value", pair);
            }
            if (attributes.length != 0 || annotations2.containsKey(qname)) continue;
            annotations2.put(qname, new LinkedHashMap());
        }
    }

    private static void collectAliasedAnnotationsFromAnnotationCollectorValueAttribute(@NotNull PsiAnnotation annotationCollector, @NotNull Map<String, Map<String, PsiNameValuePair>> annotations2) {
        PsiAnnotationMemberValue annotationsFromValue = annotationCollector.findAttributeValue("value");
        if (annotationsFromValue instanceof GrAnnotationArrayInitializer) {
            for (GrAnnotationMemberValue member : ((GrAnnotationArrayInitializer)annotationsFromValue).getInitializers()) {
                PsiElement resolved;
                if (!(member instanceof GrReferenceExpression) || !((resolved = ((GrReferenceExpression)member).resolve()) instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
                annotations2.put(((PsiClass)resolved).getQualifiedName(), new LinkedHashMap());
            }
        }
    }

    @Nullable
    public static PsiAnnotation findAnnotationCollector(@Nullable PsiClass clazz) {
        PsiModifierList modifierList;
        if (clazz != null && (modifierList = clazz.getModifierList()) != null) {
            PsiAnnotation[] annotations2;
            for (PsiAnnotation annotation : annotations2 = modifierList instanceof GrModifierList ? ((GrModifierList)modifierList).getRawAnnotations() : modifierList.getAnnotations()) {
                if (!"groovy.transform.AnnotationCollector".equals(annotation.getQualifiedName())) continue;
                return annotation;
            }
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation findAnnotationCollector(@NotNull GrAnnotation annotation) {
        if (!GrAnnotationCollector.mayHaveAnnotationCollector(annotation)) {
            return null;
        }
        PsiElement resolved = annotation.getClassReference().resolve();
        if (resolved instanceof ClsClassImpl) {
            return GrAnnotationCollector.findAnnotationCollector(((ClsClassImpl)resolved).getSourceMirrorClass());
        }
        if (resolved instanceof PsiClass) {
            return GrAnnotationCollector.findAnnotationCollector((PsiClass)resolved);
        }
        return null;
    }

    private static boolean mayHaveAnnotationCollector(GrAnnotation @NotNull [] rawAnnotations) {
        for (GrAnnotation annotation : rawAnnotations) {
            if (!GrAnnotationCollector.mayHaveAnnotationCollector(annotation)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean mayHaveAnnotationCollector(@NotNull GrAnnotation annotation) {
        String shortName = annotation.getShortName();
        Set<String> allNames = GrAnnotationCollector.allCollectorNames(annotation.getProject());
        if (allNames.contains(shortName)) return true;
        if (!ContainerUtil.exists(GroovyImports.getAliasedShortNames(annotation, shortName), allNames::contains)) return false;
        return true;
    }

    private static Set<String> allCollectorNames(@NotNull Project project) {
        return (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            HashSet result2 = new HashSet();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            for (PsiClass collector : JavaPsiFacade.getInstance((Project)project).findClasses("groovy.transform.AnnotationCollector", scope)) {
                AnnotatedElementsSearch.searchPsiClasses((PsiClass)collector, (SearchScope)scope).forEach(aClass -> {
                    ContainerUtil.addIfNotNull((Collection)result2, (Object)aClass.getName());
                    return true;
                });
            }
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static boolean collectHardcoded(@NotNull List<? super GrAnnotation> list, @NotNull GrAnnotation alias) {
        String fqn = alias.getQualifiedName();
        if ("groovy.transform.Immutable".equals(fqn)) {
            GrImmutableUtils.collectImmutableAnnotations(alias, list);
            return true;
        }
        return GrAnnotationCollector.collectCompileDynamic(list, alias);
    }

    private static boolean collectCompileDynamic(@NotNull List<? super GrAnnotation> list, @NotNull GrAnnotation alias) {
        if ("groovy.transform.CompileDynamic".equals(alias.getQualifiedName())) {
            PsiAnnotationOwner owner = alias.getOwner();
            if (owner != null) {
                GrLightAnnotation annotation = new GrLightAnnotation(owner, alias, "groovy.transform.CompileStatic", Collections.singletonMap("value", "TypeCheckingMode.SKIP"));
                list.add(annotation);
            }
            return true;
        }
        return false;
    }
}

