/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleSettingsFacade;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtilKt;

public abstract class GrReferenceElementImpl<Q extends PsiElement>
extends GroovyPsiElementImpl
implements GrReferenceElement<Q> {
    private static final String DUMMY_FQN = "05ab655a-0e15-4f35-909d-9dff5e757f63";
    private volatile String myQualifiedReferenceName = "05ab655a-0e15-4f35-909d-9dff5e757f63";

    public GrReferenceElementImpl(@NotNull ASTNode node) {
        super(node);
    }

    public void subtreeChanged() {
        this.myQualifiedReferenceName = DUMMY_FQN;
        super.subtreeChanged();
    }

    @Override
    public String getReferenceName() {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            return nameElement.getText();
        }
        return null;
    }

    @Override
    @Nullable
    public String getQualifiedReferenceName() {
        String qualifiedReferenceName = this.myQualifiedReferenceName;
        if (qualifiedReferenceName == DUMMY_FQN) {
            this.myQualifiedReferenceName = qualifiedReferenceName = PsiImplUtilKt.getQualifiedReferenceName(this);
        }
        return qualifiedReferenceName;
    }

    @NotNull
    public PsiElement getElement() {
        return this;
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiElement refNameElement = this.getReferenceNameElement();
        if (refNameElement != null) {
            int offsetInParent = refNameElement.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + refNameElement.getTextLength());
        }
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            ASTNode newNameNode;
            ASTNode node = nameElement.getNode();
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            try {
                newNameNode = factory.createReferenceNameFromText(newElementName).getNode();
            }
            catch (IncorrectOperationException e) {
                newNameNode = factory.createLiteralFromValue(newElementName).getFirstChild().getNode();
            }
            assert (newNameNode != null && node != null);
            this.getNode().replaceChild(node, newNameNode);
        }
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        boolean preserveQualification;
        if (this.isReferenceTo(element)) {
            return this;
        }
        boolean fullyQualified = this.isFullyQualified();
        boolean bl = preserveQualification = GroovyCodeStyleSettingsFacade.getInstance(this.getProject()).useFqClassNames() && fullyQualified;
        if (element instanceof PsiClass) {
            String qualifiedName = ((PsiClass)element).getQualifiedName();
            if (!preserveQualification || qualifiedName == null) {
                String newName = ((PsiClass)element).getName();
                this.setQualifier((Q)null);
                GrReferenceElementImpl newElement = (GrReferenceElementImpl)this.handleElementRename(newName);
                if (newElement.isReferenceTo(element) || qualifiedName == null || JavaPsiFacade.getInstance((Project)this.getProject()).findClass(qualifiedName, this.getResolveScope()) == null) {
                    return newElement;
                }
            }
            GrReferenceElement<Q> qualifiedRef = this.bindWithQualifiedRef(qualifiedName);
            if (!preserveQualification) {
                JavaCodeStyleManager.getInstance((Project)this.getProject()).shortenClassReferences(qualifiedRef);
            }
            return qualifiedRef;
        }
        if (element instanceof PsiMember) {
            PsiMember member = (PsiMember)element;
            PsiClass psiClass = member.getContainingClass();
            if (psiClass == null) {
                throw new IncorrectOperationException();
            }
            String qName = psiClass.getQualifiedName() + "." + member.getName();
            GrReferenceElement<Q> qualifiedRef = this.bindWithQualifiedRef(qName);
            if (!preserveQualification) {
                JavaCodeStyleManager.getInstance((Project)this.getProject()).shortenClassReferences(qualifiedRef);
            }
            return qualifiedRef;
        }
        if (element instanceof PsiPackage) {
            return this.bindWithQualifiedRef(((PsiPackage)element).getQualifiedName());
        }
        throw new IncorrectOperationException("Cannot bind to:" + element + " of class " + element.getClass());
    }

    private GrReferenceElement<Q> bindWithQualifiedRef(@NotNull String qName) {
        GrReferenceElement<Q> qualifiedRef = this.createQualifiedRef(qName);
        GrTypeArgumentList list = this.getTypeArgumentList();
        if (list != null) {
            qualifiedRef.getNode().addChild(list.copy().getNode());
        }
        this.getNode().getTreeParent().replaceChild(this.getNode(), qualifiedRef.getNode());
        return qualifiedRef;
    }

    @NotNull
    protected abstract GrReferenceElement<Q> createQualifiedRef(@NotNull String var1);

    protected boolean bindsCorrectly(PsiElement element) {
        return this.isReferenceTo(element);
    }

    public abstract boolean isFullyQualified();

    @Override
    public PsiType @NotNull [] getTypeArguments() {
        GrTypeArgumentList typeArgsList = this.getTypeArgumentList();
        if (typeArgsList == null) {
            return PsiType.EMPTY_ARRAY;
        }
        GrTypeElement[] args = typeArgsList.getTypeArgumentElements();
        if (args.length == 0) {
            return PsiType.EMPTY_ARRAY;
        }
        PsiType[] result2 = PsiType.createArray((int)args.length);
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = args[i].getType();
        }
        return result2;
    }

    @Override
    @Nullable
    public GrTypeArgumentList getTypeArgumentList() {
        return (GrTypeArgumentList)this.findChildByType(GroovyElementTypes.TYPE_ARGUMENTS);
    }

    @Override
    public void setQualifier(@Nullable Q newQualifier) {
        PsiImplUtil.setQualifier(this, newQualifier);
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }
}

