/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;

public class CallInstruction
extends InstructionImpl {
    private final InstructionImpl myCallee;

    public CallInstruction(InstructionImpl callee) {
        super(null);
        this.myCallee = callee;
    }

    @Override
    public String toString() {
        return super.toString() + " CALL " + this.myCallee.num();
    }

    @Override
    @NotNull
    public Iterable<Instruction> successors(@NotNull CallEnvironment environment) {
        environment.callStack(this.myCallee).push(this);
        return Collections.singletonList(this.myCallee);
    }

    @Override
    @NotNull
    public Iterable<Instruction> allSuccessors() {
        return Collections.singletonList(this.myCallee);
    }

    @Override
    @NotNull
    protected String getElementPresentation() {
        return "";
    }
}

