/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GrIfConditionFixer
extends SmartEnterProcessorWithFixers.Fixer<GroovySmartEnterProcessor> {
    public void apply(@NotNull Editor editor, @NotNull GroovySmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        if (psiElement instanceof GrIfStatement) {
            Document doc = editor.getDocument();
            GrIfStatement ifStatement = (GrIfStatement)psiElement;
            PsiElement rParen = ifStatement.getRParenth();
            PsiElement lParen = ifStatement.getLParenth();
            GrExpression condition = ifStatement.getCondition();
            if (condition == null) {
                if (lParen == null || rParen == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(ifStatement.getTextRange().getStartOffset()));
                    GrStatement then = ifStatement.getThenBranch();
                    if (then != null) {
                        stopOffset = Math.min(stopOffset, then.getTextRange().getStartOffset());
                    }
                    stopOffset = Math.min(stopOffset, ifStatement.getTextRange().getEndOffset());
                    doc.replaceString(ifStatement.getTextRange().getStartOffset(), stopOffset, (CharSequence)"if ()");
                    processor.registerUnresolvedError(ifStatement.getTextRange().getStartOffset() + "if (".length());
                } else {
                    processor.registerUnresolvedError(lParen.getTextRange().getEndOffset());
                }
            } else if (rParen == null) {
                doc.insertString(condition.getTextRange().getEndOffset(), (CharSequence)")");
            }
        }
    }
}

