/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;

public abstract class GrChangeMemberVisibilityModifierBase
extends Intention {
    private final String myModifier;

    public GrChangeMemberVisibilityModifierBase(String modifier) {
        this.myModifier = modifier;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof GrMember)) {
            return;
        }
        ((GrMember)parent2).getModifierList().setModifierProperty(this.myModifier, true);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                PsiElement parent2 = element.getParent();
                return parent2 instanceof GrMember && parent2 instanceof GrNamedElement && (((GrNamedElement)parent2).getNameIdentifierGroovy() == element || ((GrMember)parent2).getModifierList() == element) && ((GrMember)parent2).getModifierList() != null && !((GrMember)parent2).getModifierList().hasExplicitModifier(GrChangeMemberVisibilityModifierBase.this.myModifier);
            }
        };
    }
}

