/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighting;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;

public interface HighlightSink {
    default public void registerProblem(@NotNull PsiElement highlightElement, @NotNull String message, LocalQuickFix ... fixes) {
        this.registerProblem(highlightElement, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, message, fixes);
    }

    default public void registerError(@NotNull PsiElement highlightElement, @NotNull String message, LocalQuickFix ... fixes) {
        this.registerProblem(highlightElement, ProblemHighlightType.GENERIC_ERROR, message, fixes);
    }

    default public void registerProblem(@NotNull PsiElement highlightElement, @NotNull ProblemHighlightType highlightType, @NotNull String message, LocalQuickFix ... fixes) {
        this.registerProblem(highlightElement, highlightType, message, QuickfixUtil.fixesToIntentions(highlightElement, fixes));
    }

    default public void registerProblem(@NotNull PsiElement highlightElement, @NotNull ProblemHighlightType highlightType, @NotNull String message, @NotNull List<? extends IntentionAction> actions) {
        this.registerProblem(highlightElement, highlightType, message, QuickfixUtil.intentionsToFixes(highlightElement, actions));
    }
}

