/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.formatter.AlignmentProvider;

public class FormattingContext {
    private final CommonCodeStyleSettings mySettings;
    private final GroovyCodeStyleSettings myGroovySettings;
    private final AlignmentProvider myAlignmentProvider;
    private final boolean myForbidWrapping;
    private final boolean myForbidNewLineInSpacing;

    public FormattingContext(@NotNull CommonCodeStyleSettings settings, @NotNull AlignmentProvider provider2, @NotNull GroovyCodeStyleSettings groovySettings, boolean forbidWrapping, boolean forbidNewLineInSpacing) {
        this.mySettings = settings;
        this.myAlignmentProvider = provider2;
        this.myGroovySettings = groovySettings;
        this.myForbidWrapping = forbidWrapping;
        this.myForbidNewLineInSpacing = forbidNewLineInSpacing;
    }

    public FormattingContext(@NotNull CommonCodeStyleSettings settings, @NotNull AlignmentProvider provider2, @NotNull GroovyCodeStyleSettings groovySettings, boolean forbidWrapping) {
        this(settings, provider2, groovySettings, forbidWrapping, false);
    }

    public CommonCodeStyleSettings getSettings() {
        return this.mySettings;
    }

    public AlignmentProvider getAlignmentProvider() {
        return this.myAlignmentProvider;
    }

    public GroovyCodeStyleSettings getGroovySettings() {
        return this.myGroovySettings;
    }

    public FormattingContext createContext(boolean forbidWrapping, boolean forbidNewLineInSpacing) {
        return new FormattingContext(this.mySettings, this.myAlignmentProvider, this.myGroovySettings, this.myForbidWrapping || forbidWrapping, this.myForbidNewLineInSpacing || forbidNewLineInSpacing);
    }

    public boolean isForbidWrapping() {
        return this.myForbidWrapping;
    }

    public boolean isForbidNewLineInSpacing() {
        return this.myForbidNewLineInSpacing;
    }
}

