/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions.joinLines;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.editor.actions.joinLines.GrJoinLinesHandlerBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GrVariableJoinLinesHandler
extends GrJoinLinesHandlerBase {
    @Override
    public int tryJoinStatements(@NotNull GrStatement first, @NotNull GrStatement second) {
        if (first instanceof GrVariableDeclaration && !((GrVariableDeclaration)first).isTuple() && second instanceof GrAssignmentExpression) {
            PsiElement resolved;
            GrExpression lvalue = ((GrAssignmentExpression)second).getLValue();
            GrExpression rValue = ((GrAssignmentExpression)second).getRValue();
            if (lvalue instanceof GrReferenceExpression && rValue != null && ArrayUtil.contains((Object)(resolved = ((GrReferenceExpression)lvalue).resolve()), (Object[])((GrVariableDeclaration)first).getVariables())) {
                assert (resolved instanceof GrVariable);
                if (((GrVariable)resolved).getInitializerGroovy() == null) {
                    ((GrVariable)resolved).setInitializerGroovy(rValue);
                    PsiElement prev = rValue.getPrevSibling();
                    if (prev instanceof PsiWhiteSpace) {
                        resolved.addBefore(prev, (PsiElement)((GrVariable)resolved).getInitializerGroovy());
                    }
                    second.delete();
                    GrExpression newInitializer = ((GrVariable)resolved).getInitializerGroovy();
                    assert (newInitializer != null);
                    return newInitializer.getTextRange().getEndOffset();
                }
            }
        }
        return -1;
    }
}

