/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions.joinLines;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;

public class GrJoinBlockStatementHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        if (!(file instanceof GroovyFileBase)) {
            return -1;
        }
        PsiElement startElement = file.findElementAt(start);
        if (startElement == null || startElement.getNode().getElementType() != GroovyTokenTypes.mLCURLY) {
            return -1;
        }
        PsiElement parent2 = startElement.getParent();
        if (!(parent2 instanceof GrOpenBlock)) {
            return -1;
        }
        GrStatement[] statements2 = ((GrOpenBlock)parent2).getStatements();
        if (statements2.length != 1) {
            return -1;
        }
        PsiElement parent1 = parent2.getParent();
        if (!(parent1 instanceof GrBlockStatement)) {
            return -1;
        }
        PsiElement parent22 = parent1.getParent();
        if (!(parent22 instanceof GrIfStatement || parent22 instanceof GrWhileStatement || parent22 instanceof GrForStatement)) {
            return -1;
        }
        GrStatement statement = ((GrBlockStatement)parent1).replaceWithStatement(statements2[0]);
        return statement.getTextRange().getStartOffset();
    }
}

