/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XCollection;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="DslActivationStatus", storages={@Storage(value="dslActivation.xml", roamingType=RoamingType.DISABLED, deprecated=true), @Storage(value="dslActivationStatus.xml", roamingType=RoamingType.DISABLED)})
public class DslActivationStatus
implements PersistentStateComponent<State> {
    private final THashMap<VirtualFile, Entry> myStatus = new THashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entry getGdslFileInfo(@NotNull VirtualFile file) {
        THashMap<VirtualFile, Entry> tHashMap = this.myStatus;
        synchronized (tHashMap) {
            return (Entry)this.myStatus.get((Object)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Entry getGdslFileInfoOrCreate(@NotNull VirtualFile file) {
        Entry entry;
        THashMap<VirtualFile, Entry> tHashMap = this.myStatus;
        synchronized (tHashMap) {
            entry = (Entry)this.myStatus.get((Object)file);
            if (entry == null) {
                entry = new Entry(file.getUrl(), Status.ACTIVE, null);
                this.myStatus.put((Object)file, (Object)entry);
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public State getState() {
        THashMap<VirtualFile, Entry> tHashMap = this.myStatus;
        synchronized (tHashMap) {
            this.myStatus.retainEntries((TObjectObjectProcedure)new TObjectObjectProcedure<VirtualFile, Entry>(){

                public boolean execute(VirtualFile file, Entry entry) {
                    return entry.status != Status.ACTIVE || entry.error != null;
                }
            });
            if (this.myStatus.isEmpty()) {
                return new State(Collections.emptyList());
            }
            Object[] entries = this.myStatus.values().toArray(new Entry[this.myStatus.size()]);
            Arrays.sort(entries);
            return new State(Arrays.asList(entries));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        THashMap<VirtualFile, Entry> tHashMap = this.myStatus;
        synchronized (tHashMap) {
            this.myStatus.clear();
            if (ContainerUtil.isEmpty(state.entries)) {
                return;
            }
            VirtualFileManager fileManager = VirtualFileManager.getInstance();
            for (Entry entry : state.entries) {
                VirtualFile file;
                if (entry.url == null || entry.status == null || (file = fileManager.findFileByUrl(entry.url)) == null) continue;
                this.myStatus.put((Object)file, (Object)entry);
            }
        }
    }

    public static DslActivationStatus getInstance() {
        return (DslActivationStatus)ServiceManager.getService(DslActivationStatus.class);
    }

    public static class State {
        @XCollection
        public Collection<Entry> entries;

        public State(@NotNull Collection<Entry> entries) {
            this.entries = entries;
        }

        public State() {
            this((Collection<Entry>)new SmartList());
        }
    }

    public static class Entry
    implements Comparable<Entry> {
        @Attribute
        public String url;
        @Attribute
        public Status status;
        @Attribute
        public String error;

        public Entry() {
        }

        public Entry(String url, Status status, String error) {
            this.url = url;
            this.status = status;
            this.error = error;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.url != null ? !this.url.equals(entry.url) : entry.url != null) {
                return false;
            }
            if (this.status != entry.status) {
                return false;
            }
            return !(this.error != null ? !this.error.equals(entry.error) : entry.error != null);
        }

        public int hashCode() {
            int result2 = this.url != null ? this.url.hashCode() : 0;
            result2 = 31 * result2 + (this.status != null ? this.status.hashCode() : 0);
            result2 = 31 * result2 + (this.error != null ? this.error.hashCode() : 0);
            return result2;
        }

        @Override
        public int compareTo(Entry o) {
            return this.equals(o) ? 0 : this.url.compareTo(o.url);
        }
    }

    static enum Status {
        ACTIVE,
        MODIFIED,
        ERROR;

    }
}

