/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PointersKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrCastFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\fH\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/ParameterCastFix;", "Lorg/jetbrains/plugins/groovy/codeInspection/GroovyFix;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "position", "", "myType", "Lcom/intellij/psi/PsiType;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;ILcom/intellij/psi/PsiType;)V", "myExpression", "Lcom/intellij/model/Pointer;", "myName", "", "doFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "intellij.groovy.psi"})
public final class ParameterCastFix
extends GroovyFix {
    private final String myName;
    private final Pointer<GrExpression> myExpression;
    private final PsiType myType;

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getFamilyName() {
        return "Add parameter cast";
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        GrExpression grExpression = (GrExpression)this.myExpression.dereference();
        if (grExpression == null) {
            return;
        }
        GrExpression expression = grExpression;
        GrCastFix.doSafeCast(project, this.myType, expression);
    }

    public ParameterCastFix(@NotNull GrExpression expression, int position, @NotNull PsiType myType2) {
        this.myType = myType2;
        this.myName = GroovyBundle.message("parameter.cast.fix", position + 1, this.myType.getPresentableText());
        this.myExpression = (Pointer)PointersKt.createSmartPointer$default((PsiElement)expression, null, (int)1, null);
    }
}

