/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.gpath;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyMapPutCanBeKeyedAccessInspection
extends BaseInspection {
    private final ReplaceWithPropertyAccessFix fix = new ReplaceWithPropertyAccessFix();

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Call to '#ref' can be keyed access #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        return this.fix;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull GrMethodCallExpression grMethodCallExpression) {
            super.visitMethodCallExpression(grMethodCallExpression);
            GrArgumentList args = grMethodCallExpression.getArgumentList();
            if (args.getExpressionArguments().length != 2) {
                return;
            }
            if (PsiImplUtil.hasNamedArguments(args)) {
                return;
            }
            GrExpression methodExpression = grMethodCallExpression.getInvokedExpression();
            if (!(methodExpression instanceof GrReferenceExpression)) {
                return;
            }
            GrReferenceExpression referenceExpression = (GrReferenceExpression)methodExpression;
            String name = referenceExpression.getReferenceName();
            if (!"put".equals(name)) {
                return;
            }
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier == null || PsiUtil.isThisOrSuperRef(qualifier)) {
                return;
            }
            if (referenceExpression.getDotTokenType() == GroovyTokenTypes.mOPTIONAL_DOT) {
                return;
            }
            PsiType type2 = qualifier.getType();
            if (!InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map")) {
                return;
            }
            this.registerMethodCallError(grMethodCallExpression, new Object[0]);
        }
    }

    private static class ReplaceWithPropertyAccessFix
    extends GroovyFix {
        private ReplaceWithPropertyAccessFix() {
        }

        @NotNull
        public String getFamilyName() {
            return "Replace with keyed access";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement referenceName = descriptor.getPsiElement();
            GrReferenceExpression invokedExpression = (GrReferenceExpression)referenceName.getParent();
            GrMethodCallExpression callExpression = (GrMethodCallExpression)invokedExpression.getParent();
            GrArgumentList argumentList = callExpression.getArgumentList();
            GrExpression[] args = argumentList.getExpressionArguments();
            ReplaceWithPropertyAccessFix.replaceExpression(callExpression, invokedExpression.getQualifierExpression().getText() + '[' + args[0].getText() + "]=" + args[1].getText());
        }
    }
}

