/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations.Transformation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;

public class UnaryTransformation
extends Transformation<GrUnaryExpression> {
    @NotNull
    private final String myMethod;

    public UnaryTransformation(@NotNull String method) {
        this.myMethod = method;
    }

    @Override
    public void apply(@NotNull GrUnaryExpression expression) {
        GrExpression operand = this.addParenthesesIfNeeded(Objects.requireNonNull(UnaryTransformation.getOperand(expression)));
        GrInspectionUtil.replaceExpression(expression, String.format("%s.%s()", operand.getText(), this.myMethod));
    }

    @Override
    @NotNull
    public String getMethod() {
        return this.myMethod;
    }

    @Override
    @Nullable
    protected GrUnaryExpression checkCast(@NotNull GrExpression expression) {
        return expression instanceof GrUnaryExpression ? (GrUnaryExpression)expression : null;
    }

    @Override
    public boolean couldApply(@NotNull GrUnaryExpression expression) {
        GrExpression operand = UnaryTransformation.getOperand(expression);
        return operand != null;
    }

    @Nullable
    public static GrExpression getOperand(@NotNull GrUnaryExpression callExpression) {
        return callExpression.getOperand();
    }
}

