/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations.Transformation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

abstract class BinaryTransformation
extends Transformation<GrBinaryExpression> {
    BinaryTransformation() {
    }

    @NotNull
    protected GrExpression getLhs(@NotNull GrBinaryExpression expression) {
        return ParenthesesUtils.unparenthesize(Objects.requireNonNull(expression.getLeftOperand()));
    }

    @NotNull
    protected GrExpression getRhs(@NotNull GrBinaryExpression expression) {
        return ParenthesesUtils.unparenthesize(Objects.requireNonNull(expression.getRightOperand()));
    }

    @Override
    @Nullable
    protected GrBinaryExpression checkCast(@NotNull GrExpression expression) {
        return expression instanceof GrBinaryExpression ? (GrBinaryExpression)expression : null;
    }

    @Override
    public boolean couldApply(@NotNull GrBinaryExpression expression) {
        return expression.getRightOperand() != null;
    }
}

