/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation.GrAnnotationImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class FieldAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        PsiElement ownerToUse;
        String qname = annotation.getQualifiedName();
        if (!"groovy.transform.Field".equals(qname)) {
            return false;
        }
        FieldAnnotationChecker.checkScriptField(holder, annotation);
        PsiElement annoParent = annotation.getParent();
        PsiElement psiElement = ownerToUse = annoParent instanceof PsiModifierList ? annoParent.getParent() : annoParent;
        if (!(ownerToUse instanceof GrVariableDeclaration)) {
            return false;
        }
        GrVariableDeclaration declaration = (GrVariableDeclaration)ownerToUse;
        if (declaration.getVariables().length != 1 || !PsiUtil.isLocalVariable(declaration.getVariables()[0])) {
            return false;
        }
        if (!GrAnnotationImpl.isAnnotationApplicableTo(annotation, PsiAnnotation.TargetType.LOCAL_VARIABLE)) {
            GrCodeReferenceElement ref = annotation.getClassReference();
            String target = JavaAnalysisBundle.message((String)"annotation.target.LOCAL_VARIABLE", (Object[])new Object[0]);
            String description = JavaErrorBundle.message((String)"annotation.not.applicable", (Object[])new Object[]{ref.getText(), target});
            holder.newAnnotation(HighlightSeverity.ERROR, description).range((PsiElement)ref).create();
        }
        return true;
    }

    private static void checkScriptField(AnnotationHolder holder, GrAnnotation annotation) {
        PsiAnnotationOwner owner = annotation.getOwner();
        GrMember container = (GrMember)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)owner), GrMember.class);
        if (container != null) {
            String message = container.getContainingClass() instanceof GroovyScriptClass ? GroovyBundle.message("annotation.field.can.only.be.used.within.a.script.body", new Object[0]) : GroovyBundle.message("annotation.field.can.only.be.used.within.a.script", new Object[0]);
            holder.newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)annotation).create();
        }
    }
}

