/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;

public class BaseScriptAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        if ("groovy.transform.BaseScript".equals(annotation.getQualifiedName())) {
            PsiClass clazz;
            PsiFile file = annotation.getContainingFile();
            if (file instanceof GroovyFile && !((GroovyFile)file).isScript()) {
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("base.script.annotation.is.allowed.only.inside.scripts", new Object[0])).range((PsiElement)annotation).create();
                return true;
            }
            PsiElement pparent = annotation.getParent().getParent();
            if (pparent instanceof GrVariableDeclaration) {
                PsiType type2;
                GrTypeElement typeElement = ((GrVariableDeclaration)pparent).getTypeElementGroovy();
                PsiType psiType = type2 = typeElement != null ? typeElement.getType() : null;
                if (!InheritanceUtil.isInheritor((PsiType)type2, (String)"groovy.lang.Script")) {
                    String typeText = type2 != null ? type2.getCanonicalText() : "java.lang.Object";
                    holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("declared.type.0.have.to.extend.script", typeText)).range((PsiElement)annotation).create();
                    return true;
                }
            } else if ((pparent instanceof GrPackageDefinition || pparent instanceof GrImportStatement) && !InheritanceUtil.isInheritor((PsiClass)(clazz = GrAnnotationUtil.inferClassAttribute(annotation, "value")), (String)"groovy.lang.Script")) {
                String typeText = this.getTypeText(clazz);
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("declared.type.0.have.to.extend.script", typeText)).range((PsiElement)annotation).create();
            }
        }
        return false;
    }

    @NotNull
    public String getTypeText(@Nullable PsiClass clazz) {
        if (clazz == null) {
            return "java.lang.Object";
        }
        String fqn = clazz.getQualifiedName();
        if (fqn != null) {
            return fqn;
        }
        String name = clazz.getName();
        if (name != null) {
            return name;
        }
        return "java.lang.Object";
    }
}

