/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.diagnostic.LoadingState;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.IllegalEnvVarException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.IdeUtilIoBundle;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCommandLine
implements UserDataHolder {
    private static final Logger LOG = Logger.getInstance(GeneralCommandLine.class);
    private String myExePath;
    private File myWorkDirectory;
    private final Map<String, String> myEnvParams = new MyTHashMap();
    private ParentEnvironmentType myParentEnvironmentType = ParentEnvironmentType.CONSOLE;
    private final ParametersList myProgramParams = new ParametersList();
    private Charset myCharset = GeneralCommandLine.defaultCharset();
    private boolean myRedirectErrorStream;
    private File myInputFile;
    private Map<Object, Object> myUserData;

    public GeneralCommandLine() {
    }

    public GeneralCommandLine(String ... command) {
        this(Arrays.asList(command));
    }

    public GeneralCommandLine(@NonNls @NotNull List<String> command) {
        int size = command.size();
        if (size > 0) {
            this.setExePath(command.get(0));
            if (size > 1) {
                this.addParameters(command.subList(1, size));
            }
        }
    }

    protected GeneralCommandLine(@NotNull GeneralCommandLine original) {
        this.myExePath = original.myExePath;
        this.myWorkDirectory = original.myWorkDirectory;
        this.myEnvParams.putAll(original.myEnvParams);
        this.myParentEnvironmentType = original.myParentEnvironmentType;
        original.myProgramParams.copyTo(this.myProgramParams);
        this.myCharset = original.myCharset;
        this.myRedirectErrorStream = original.myRedirectErrorStream;
        this.myInputFile = original.myInputFile;
        this.myUserData = null;
    }

    private static Charset defaultCharset() {
        return LoadingState.COMPONENTS_LOADED.isOccurred() ? EncodingManager.getInstance().getDefaultConsoleEncoding() : Charset.defaultCharset();
    }

    @NotNull
    public String getExePath() {
        return this.myExePath;
    }

    @NotNull
    public GeneralCommandLine withExePath(@NotNull String exePath) {
        this.myExePath = exePath.trim();
        return this;
    }

    public void setExePath(@NotNull String exePath) {
        this.withExePath(exePath);
    }

    public File getWorkDirectory() {
        return this.myWorkDirectory;
    }

    @NotNull
    public GeneralCommandLine withWorkDirectory(@Nullable String path) {
        return this.withWorkDirectory(path != null ? new File(path) : null);
    }

    @NotNull
    public GeneralCommandLine withWorkDirectory(@Nullable File workDirectory) {
        this.myWorkDirectory = workDirectory;
        return this;
    }

    public void setWorkDirectory(@Nullable String path) {
        this.withWorkDirectory(path);
    }

    public void setWorkDirectory(@Nullable File workDirectory) {
        this.withWorkDirectory(workDirectory);
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        return this.myEnvParams;
    }

    @NotNull
    public GeneralCommandLine withEnvironment(@Nullable Map<String, String> environment) {
        if (environment != null) {
            this.getEnvironment().putAll(environment);
        }
        return this;
    }

    @NotNull
    public GeneralCommandLine withEnvironment(@NotNull String key, @NotNull String value) {
        this.getEnvironment().put(key, value);
        return this;
    }

    public boolean isPassParentEnvironment() {
        return this.myParentEnvironmentType != ParentEnvironmentType.NONE;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setPassParentEnvironment(boolean passParentEnvironment) {
        this.withParentEnvironmentType(passParentEnvironment ? ParentEnvironmentType.CONSOLE : ParentEnvironmentType.NONE);
    }

    @NotNull
    public ParentEnvironmentType getParentEnvironmentType() {
        return this.myParentEnvironmentType;
    }

    @NotNull
    public GeneralCommandLine withParentEnvironmentType(@NotNull ParentEnvironmentType type) {
        this.myParentEnvironmentType = type;
        return this;
    }

    @NotNull
    public Map<String, String> getParentEnvironment() {
        switch (this.myParentEnvironmentType) {
            case SYSTEM: {
                return System.getenv();
            }
            case CONSOLE: {
                return EnvironmentUtil.getEnvironmentMap();
            }
        }
        return Collections.emptyMap();
    }

    @NotNull
    public Map<String, String> getEffectiveEnvironment() {
        MyTHashMap env = new MyTHashMap();
        this.setupEnvironment((Map<String, String>)((Object)env));
        return env;
    }

    public void addParameters(String ... parameters) {
        this.withParameters(parameters);
    }

    public void addParameters(@NotNull List<String> parameters) {
        this.withParameters(parameters);
    }

    @NotNull
    public GeneralCommandLine withParameters(String ... parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
        return this;
    }

    @NotNull
    public GeneralCommandLine withParameters(@NotNull List<String> parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
        return this;
    }

    public void addParameter(@NotNull String parameter) {
        this.myProgramParams.add(parameter);
    }

    @NotNull
    public ParametersList getParametersList() {
        return this.myProgramParams;
    }

    @NotNull
    public Charset getCharset() {
        return this.myCharset;
    }

    @NotNull
    public GeneralCommandLine withCharset(@NotNull Charset charset) {
        this.myCharset = charset;
        return this;
    }

    public void setCharset(@NotNull Charset charset) {
        this.withCharset(charset);
    }

    public boolean isRedirectErrorStream() {
        return this.myRedirectErrorStream;
    }

    @NotNull
    public GeneralCommandLine withRedirectErrorStream(boolean redirectErrorStream) {
        this.myRedirectErrorStream = redirectErrorStream;
        return this;
    }

    public void setRedirectErrorStream(boolean redirectErrorStream) {
        this.withRedirectErrorStream(redirectErrorStream);
    }

    public File getInputFile() {
        return this.myInputFile;
    }

    @NotNull
    public GeneralCommandLine withInput(@Nullable File file) {
        this.myInputFile = file;
        return this;
    }

    @NotNull
    public String getCommandLineString() {
        return this.getCommandLineString(null);
    }

    @NotNull
    public String getCommandLineString(@Nullable String exeName) {
        return ParametersListUtil.join(this.getCommandLineList(exeName));
    }

    @NotNull
    public List<String> getCommandLineList(@Nullable String exeName) {
        ArrayList<String> commands = new ArrayList<String>();
        if (exeName != null) {
            commands.add(exeName);
        } else if (this.myExePath != null) {
            commands.add(this.myExePath);
        } else {
            commands.add("<null>");
        }
        commands.addAll(this.myProgramParams.getList());
        return commands;
    }

    @NotNull
    public String getPreparedCommandLine() {
        return this.getPreparedCommandLine(Platform.current());
    }

    @NotNull
    public String getPreparedCommandLine(@NotNull Platform platform) {
        String exePath = this.myExePath != null ? this.myExePath : "";
        return StringUtil.join(this.prepareCommandLine(exePath, this.myProgramParams.getList(), platform), (String)"\n");
    }

    @NotNull
    protected List<String> prepareCommandLine(@NotNull String command, @NotNull List<String> parameters, @NotNull Platform platform) {
        return CommandLineUtil.toCommandLine((String)command, parameters, (Platform)platform);
    }

    @NotNull
    public Process createProcess() throws ExecutionException {
        File exeFile;
        String shellPath;
        String systemPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing [" + this.getCommandLineString() + "]");
            LOG.debug("  environment: " + this.myEnvParams + " (+" + (Object)((Object)this.myParentEnvironmentType) + ")");
            LOG.debug("  charset: " + this.myCharset);
        }
        try {
            if (this.myWorkDirectory != null) {
                if (!this.myWorkDirectory.exists()) {
                    throw new ExecutionException(IdeUtilIoBundle.message("run.configuration.error.working.directory.does.not.exist", this.myWorkDirectory));
                }
                if (!this.myWorkDirectory.isDirectory()) {
                    throw new ExecutionException(IdeUtilIoBundle.message("run.configuration.error.working.directory.not.directory", this.myWorkDirectory));
                }
            }
            if (StringUtil.isEmptyOrSpaces((String)this.myExePath)) {
                throw new ExecutionException(IdeUtilIoBundle.message("run.configuration.error.executable.not.specified", new Object[0]));
            }
        }
        catch (ExecutionException e) {
            LOG.debug((Throwable)e);
            throw e;
        }
        for (Map.Entry<String, String> entry : this.myEnvParams.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!EnvironmentUtil.isValidName((String)name)) {
                throw new IllegalEnvVarException(IdeUtilIoBundle.message("run.configuration.invalid.env.name", name));
            }
            if (EnvironmentUtil.isValidValue((String)value)) continue;
            throw new IllegalEnvVarException(IdeUtilIoBundle.message("run.configuration.invalid.env.value", name, value));
        }
        String exePath = this.myExePath;
        if (SystemInfo.isMac && this.myParentEnvironmentType == ParentEnvironmentType.CONSOLE && exePath.indexOf(File.separatorChar) == -1 && !Objects.equals(systemPath = System.getenv("PATH"), shellPath = EnvironmentUtil.getValue((String)"PATH")) && (exeFile = PathEnvironmentVariableUtil.findInPath(this.myExePath, shellPath, null)) != null) {
            LOG.debug(exePath + " => " + exeFile);
            exePath = exeFile.getPath();
        }
        List<String> commands = this.prepareCommandLine(exePath, this.myProgramParams.getList(), Platform.current());
        try {
            return this.startProcess(commands);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            throw new ProcessNotCreatedException(e.getMessage(), e, this);
        }
    }

    @NotNull
    protected Process startProcess(@NotNull List<String> escapedCommands) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Building process with commands: " + escapedCommands);
        }
        ProcessBuilder builder = new ProcessBuilder(escapedCommands);
        this.setupEnvironment(builder.environment());
        builder.directory(this.myWorkDirectory);
        builder.redirectErrorStream(this.myRedirectErrorStream);
        if (this.myInputFile != null) {
            builder.redirectInput(ProcessBuilder.Redirect.from(this.myInputFile));
        }
        return this.buildProcess(builder).start();
    }

    @NotNull
    protected ProcessBuilder buildProcess(@NotNull ProcessBuilder builder) {
        return builder;
    }

    protected void setupEnvironment(@NotNull Map<String, String> environment) {
        File workDirectory;
        environment.clear();
        if (this.myParentEnvironmentType != ParentEnvironmentType.NONE) {
            environment.putAll(this.getParentEnvironment());
        }
        if (SystemInfo.isUnix && (workDirectory = this.getWorkDirectory()) != null) {
            environment.put("PWD", FileUtil.toSystemDependentName((String)workDirectory.getAbsolutePath()));
        }
        if (!this.myEnvParams.isEmpty()) {
            if (SystemInfo.isWindows) {
                THashMap envVars = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
                envVars.putAll(environment);
                envVars.putAll(this.myEnvParams);
                environment.clear();
                environment.putAll((Map<String, String>)envVars);
            } else {
                environment.putAll(this.myEnvParams);
            }
        }
    }

    @NotNull
    public static String inescapableQuote(@NotNull String parameter) {
        return CommandLineUtil.specialQuote((String)parameter);
    }

    public String toString() {
        return this.myExePath + " " + this.myProgramParams;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (this.myUserData == null) {
            return null;
        }
        Object t = this.myUserData.get(key);
        return (T)t;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (this.myUserData == null) {
            if (value == null) {
                return;
            }
            this.myUserData = new HashMap<Object, Object>();
        }
        this.myUserData.put(key, value);
    }

    private static class MyTHashMap
    extends THashMap<String, String> {
        private MyTHashMap() {
            super((TObjectHashingStrategy)(SystemInfo.isWindows ? CaseInsensitiveStringHashingStrategy.INSTANCE : ContainerUtil.canonicalStrategy()));
        }

        public void putAll(Map<? extends String, ? extends String> map) {
            if (map != null) {
                super.putAll(map);
            }
        }
    }

    public static enum ParentEnvironmentType {
        NONE,
        SYSTEM,
        CONSOLE;

    }
}

