/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.dialogs;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundleIndependent;
import org.jetbrains.kotlin.idea.findUsages.KotlinPropertyFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.dialogs.Utils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public class KotlinFindPropertyUsagesDialog
extends JavaFindUsagesDialog<KotlinPropertyFindUsagesOptions> {
    private StateRestoringCheckBox readAccesses;
    private StateRestoringCheckBox writeAccesses;
    private StateRestoringCheckBox overrideUsages;
    private StateRestoringCheckBox expectedUsages;
    private static final boolean disableComponentAndDestructionSearchDefault = false;
    private static final String optionName = "kotlin.disable.search.component.and.destruction";

    public KotlinFindPropertyUsagesDialog(PsiElement element2, Project project, KotlinPropertyFindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        super(element2, project, (FindUsagesOptions)findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler);
    }

    @NotNull
    protected KotlinPropertyFindUsagesOptions getFindUsagesOptions() {
        KotlinPropertyFindUsagesOptions kotlinPropertyFindUsagesOptions = (KotlinPropertyFindUsagesOptions)this.myFindUsagesOptions;
        if (kotlinPropertyFindUsagesOptions == null) {
            KotlinFindPropertyUsagesDialog.$$$reportNull$$$0(0);
        }
        return kotlinPropertyFindUsagesOptions;
    }

    public JComponent getPreferredFocusedControl() {
        return this.myCbToSkipResultsWhenOneUsage;
    }

    public void calcFindUsagesOptions(KotlinPropertyFindUsagesOptions options) {
        super.calcFindUsagesOptions((JavaFindUsagesOptions)options);
        options.isReadAccess = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.readAccesses);
        options.isWriteAccess = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.writeAccesses);
        options.setSearchOverrides(KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.overrideUsages));
        if (this.expectedUsages != null) {
            options.setSearchExpected(this.expectedUsages.isSelected());
        }
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message((String)"find.what.group", (Object[])new Object[0]), (boolean)true));
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        KotlinPropertyFindUsagesOptions options = this.getFindUsagesOptions();
        this.readAccesses = this.addCheckboxToPanel(KotlinBundleIndependent.message("find.declaration.property.readers.checkbox", new Object[0]), options.isReadAccess, findWhatPanel, true);
        this.writeAccesses = this.addCheckboxToPanel(KotlinBundleIndependent.message("find.declaration.property.writers.checkbox", new Object[0]), options.isWriteAccess, findWhatPanel, true);
        return findWhatPanel;
    }

    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        if (coloredComponent == null) {
            KotlinFindPropertyUsagesDialog.$$$reportNull$$$0(1);
        }
        Utils.configureLabelComponent(coloredComponent, (KtNamedDeclaration)this.getPsiElement());
    }

    protected void addUsagesOptions(JPanel optionsPanel) {
        super.addUsagesOptions(optionsPanel);
        KtNamedDeclaration property = (KtNamedDeclaration)this.getPsiElement();
        boolean isAbstract = property.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean isOpen = property.hasModifier(KtTokens.OPEN_KEYWORD);
        if (isOpen || isAbstract) {
            this.overrideUsages = this.addCheckboxToPanel(isAbstract ? KotlinBundleIndependent.message("find.declaration.implementing.properties.checkbox", new Object[0]) : KotlinBundleIndependent.message("find.declaration.overriding.properties.checkbox", new Object[0]), FindSettings.getInstance().isSearchOverloadedMethods(), optionsPanel, false);
        }
        boolean isActual = PsiUtilsKt.hasActualModifier((KtModifierListOwner)property);
        KotlinPropertyFindUsagesOptions options = this.getFindUsagesOptions();
        if (isActual) {
            this.expectedUsages = this.addCheckboxToPanel(KotlinBundleIndependent.message("find.usages.checkbox.name.expected.properties", new Object[0]), options.getSearchExpected(), optionsPanel, false);
        }
        if (KotlinFindPropertyUsagesDialog.isDataClassConstructorProperty(property)) {
            JCheckBox dataClassComponentCheckBox = new JCheckBox(KotlinBundleIndependent.message("find.usages.checkbox.text.fast.data.class.component.search", new Object[0]));
            dataClassComponentCheckBox.setToolTipText(KotlinBundleIndependent.message("find.usages.tool.tip.text.disable.search.for.data.class.components.and.destruction.declarations.project.wide.setting", new Object[0]));
            Project project = property.getProject();
            dataClassComponentCheckBox.setSelected(KotlinFindPropertyUsagesDialog.getDisableComponentAndDestructionSearch(project));
            optionsPanel.add(dataClassComponentCheckBox);
            dataClassComponentCheckBox.addActionListener(___ -> KotlinFindPropertyUsagesDialog.setDisableComponentAndDestructionSearch(project, dataClassComponentCheckBox.isSelected()));
        }
    }

    protected void update() {
        this.setOKActionEnabled(KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.readAccesses) || KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.writeAccesses));
    }

    public static boolean getDisableComponentAndDestructionSearch(Project project) {
        return PropertiesComponent.getInstance((Project)project).getBoolean(optionName, false);
    }

    public static void setDisableComponentAndDestructionSearch(Project project, boolean value) {
        PropertiesComponent.getInstance((Project)project).setValue(optionName, value, false);
    }

    private static boolean isDataClassConstructorProperty(KtNamedDeclaration declaration) {
        PsiElement parent;
        if (declaration instanceof KtParameter && (parent = declaration.getParent()) instanceof KtParameterList && (parent = parent.getParent()) instanceof KtPrimaryConstructor && (parent = parent.getParent()) instanceof KtClass) {
            return ((KtClass)parent).isData();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindPropertyUsagesDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindPropertyUsagesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configureLabelComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

