/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.gradle;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\nJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/GradleHeuristicHelper;", "", "()V", "PRODUCTION_DEPENDENCY_STATEMENTS", "", "", "getPRODUCTION_DEPENDENCY_STATEMENTS", "()Ljava/util/Set;", "findStatementWithPrefix", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "prefix", "findStatementWithPrefixes", "prefixes", "getHeuristicVersionInBuildScriptDependency", "classpathStatement", "resolveVariableInBuildScript", "name", "kotlin.gradle.gradle-idea"})
public final class GradleHeuristicHelper {
    @NotNull
    private static final Set<String> PRODUCTION_DEPENDENCY_STATEMENTS;
    @NotNull
    public static final GradleHeuristicHelper INSTANCE;

    @NotNull
    public final Set<String> getPRODUCTION_DEPENDENCY_STATEMENTS() {
        return PRODUCTION_DEPENDENCY_STATEMENTS;
    }

    @Nullable
    public final String getHeuristicVersionInBuildScriptDependency(@NotNull GrCallExpression classpathStatement) {
        Object object;
        GrArgumentList grArgumentList;
        Intrinsics.checkNotNullParameter((Object)classpathStatement, (String)"classpathStatement");
        GrCallExpression grCallExpression = classpathStatement;
        if (grCallExpression instanceof GrMethodCall) {
            grArgumentList = ((GrMethodCall)classpathStatement).getArgumentList();
        } else {
            PsiElement $this$getChildrenOfType$iv = (PsiElement)classpathStatement;
            boolean $i$f$getChildrenOfType = false;
            object = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, GrCommandArgumentList.class);
            grArgumentList = (GrArgumentList)ArraysKt.singleOrNull((Object[])(object == null ? (PsiElement[])new GrCommandArgumentList[0] : object));
        }
        if (grArgumentList == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)grArgumentList, (String)"when (classpathStatement\u2026\n        } ?: return null");
        GrArgumentList argumentList = grArgumentList;
        Object[] objectArray = argumentList.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"argumentList.children");
        Object object2 = ArraysKt.firstOrNull((Object[])objectArray);
        if (!(object2 instanceof GrLiteral)) {
            object2 = null;
        }
        GrLiteral grLiteral = (GrLiteral)object2;
        if (grLiteral == null) {
            return null;
        }
        GrLiteral grLiteral2 = grLiteral;
        if (grLiteral2 instanceof GrString && ((GrString)grLiteral2).getInjections().length == 1) {
            GrReferenceExpression grReferenceExpression;
            Object[] objectArray2 = ((GrString)grLiteral2).getInjections();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"grLiteral.injections");
            GrStringInjection grStringInjection = (GrStringInjection)ArraysKt.first((Object[])objectArray2);
            if (grStringInjection == null) {
                return null;
            }
            GrStringInjection versionInjection = grStringInjection;
            GrExpression grExpression = versionInjection.getExpression();
            if (!(grExpression instanceof GrReferenceExpression)) {
                grExpression = null;
            }
            if ((grReferenceExpression = (GrReferenceExpression)grExpression) == null) {
                GrClosableBlock grClosableBlock = versionInjection.getClosableBlock();
                if (grClosableBlock != null) {
                    PsiElement $this$getChildrenOfType$iv = (PsiElement)grClosableBlock;
                    boolean $i$f$getChildrenOfType = false;
                    PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, GrReferenceExpression.class);
                    grReferenceExpression = (GrReferenceExpression)ArraysKt.singleOrNull((Object[])((GrReferenceExpression[])(psiElementArray == null ? (PsiElement[])new GrReferenceExpression[0] : psiElementArray)));
                } else {
                    grReferenceExpression = null;
                }
            }
            if (grReferenceExpression == null) {
                return null;
            }
            GrReferenceExpression expression = grReferenceExpression;
            String string = expression.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expression.text");
            return this.resolveVariableInBuildScript(classpathStatement, string);
        }
        Object object3 = grLiteral2.getValue();
        if (object3 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"grLiteral.value ?: return null");
        Object literalValue = object3;
        String versionText = StringsKt.substringAfterLast$default((String)literalValue.toString(), (char)':', null, (int)2, null);
        object = versionText;
        boolean bl = false;
        if (object.length() == 0) {
            return null;
        }
        return versionText;
    }

    private final String resolveVariableInBuildScript(GrCallExpression classpathStatement, String name) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)classpathStatement;
        boolean $i$f$getStrictParentOfType = false;
        GrClosableBlock grClosableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, GrClosableBlock.class, (boolean)true);
        if (grClosableBlock == null) {
            return null;
        }
        GrClosableBlock dependenciesClosure = grClosableBlock;
        PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)dependenciesClosure;
        boolean $i$f$getStrictParentOfType2 = false;
        GrClosableBlock grClosableBlock2 = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, GrClosableBlock.class, (boolean)true);
        if (grClosableBlock2 == null) {
            return null;
        }
        GrClosableBlock buildScriptClosure = grClosableBlock2;
        for (PsiElement child : buildScriptClosure.getChildren()) {
            PsiElement psiElement = child;
            if (psiElement instanceof GrAssignmentExpression) {
                GrExpression assignValue;
                GrExpression grExpression = ((GrAssignmentExpression)child).getLValue();
                Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"child.lValue");
                if (!Intrinsics.areEqual((Object)grExpression.getText(), (Object)("ext." + name)) || !((assignValue = ((GrAssignmentExpression)child).getRValue()) instanceof GrLiteral)) continue;
                return String.valueOf(((GrLiteral)assignValue).getValue());
            }
            if (!(psiElement instanceof GrVariableDeclaration)) continue;
            GrVariable[] grVariableArray = ((GrVariableDeclaration)child).getVariables();
            int n = grVariableArray.length;
            for (int i = 0; i < n; ++i) {
                GrExpression assignValue;
                GrVariable variable;
                GrVariable grVariable = variable = grVariableArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)grVariable, (String)"variable");
                if (!Intrinsics.areEqual((Object)grVariable.getName(), (Object)name) || !((assignValue = variable.getInitializerGroovy()) instanceof GrLiteral)) continue;
                return String.valueOf(((GrLiteral)assignValue).getValue());
            }
        }
        return null;
    }

    @NotNull
    public final List<GrCallExpression> findStatementWithPrefix(@NotNull GrClosableBlock closure, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return this.findStatementWithPrefixes(closure, SetsKt.setOf((Object)prefix));
    }

    @NotNull
    public final List<GrCallExpression> findStatementWithPrefixes(@NotNull GrClosableBlock closure, @NotNull Set<String> prefixes) {
        Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
        Intrinsics.checkNotNullParameter(prefixes, (String)"prefixes");
        PsiElement $this$getChildrenOfType$iv = (PsiElement)closure;
        boolean $i$f$getChildrenOfType = false;
        PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, GrCallExpression.class);
        GrCallExpression[] applicationStatements = (GrCallExpression[])(psiElementArray == null ? (PsiElement[])new GrCallExpression[0] : psiElementArray);
        ArrayList<GrCallExpression> classPathStatements = new ArrayList<GrCallExpression>();
        for (GrCallExpression statement : applicationStatements) {
            String expressionText;
            GrReferenceExpression startExpression;
            PsiElement $this$getChildrenOfType$iv2 = (PsiElement)statement;
            boolean $i$f$getChildrenOfType2 = false;
            Object[] objectArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv2, GrReferenceExpression.class);
            if ((GrReferenceExpression)ArraysKt.firstOrNull((Object[])(objectArray == null ? (PsiElement[])new GrReferenceExpression[0] : objectArray)) == null) {
                continue;
            }
            if (startExpression.getText() == null) {
                continue;
            }
            if (!prefixes.contains(expressionText)) continue;
            classPathStatements.add(statement);
        }
        return classPathStatements;
    }

    private GradleHeuristicHelper() {
    }

    static {
        GradleHeuristicHelper gradleHeuristicHelper;
        INSTANCE = gradleHeuristicHelper = new GradleHeuristicHelper();
        PRODUCTION_DEPENDENCY_STATEMENTS = SetsKt.setOf((Object[])new String[]{"classpath", "compile", "api", "implementation", "compileOnly", "runtimeOnly"});
    }
}

