from .. import mx, qt
from .QApplication import QApplication
from .StyleColor import StyleColor 
from .QStyle import QStyle
from .QWidget import QWidget


class QTimelineWidget(QWidget):
           
    def __init__(self, q_widget=None):
        super().__init__(q_widget=q_widget)
        
        self._frame_count = 0
        self._begin_frame_idx = 0
        self._end_frame_idx = 0
        self._view_start_idx = 0
        self._view_end_idx = 0
        self._frame_idx = 0
        self._frame_cursor_x = 0
        self._begin_frame_cursor_x = 0
        self._end_frame_cursor_x = 0
        
        self._mouse_down_pt : qt.QPoint = None
        self._dragging = False
        self._frame_dragging_delta_f = 0.0
        
        self._qp = qt.QPainter()
        
        q_main_widget = self.get_q_widget()
        q_canvas_widget = self.__q_canvas_widget = qt.QWidget()
        
        qt.wrap(q_canvas_widget, 'minimumSizeHint', self._q_canvas_minimumSizeHint)
        qt.wrap(q_canvas_widget, 'resizeEvent', self._q_canvas_resizeEvent)
        qt.wrap(q_canvas_widget, 'mouseMoveEvent', self._q_canvas_mouseMoveEvent)
        qt.wrap(q_canvas_widget, 'mousePressEvent', self._q_canvas_mousePressEvent)
        qt.wrap(q_canvas_widget, 'mouseReleaseEvent', self._q_canvas_mouseReleaseEvent)
        qt.wrap(q_canvas_widget, 'leaveEvent', self._q_canvas_leaveEvent)
        qt.wrap(q_canvas_widget, 'paintEvent', self._q_canvas_paintEvent)
        
        
        q_widget_l = qt.QVBox()
        q_widget_l.addWidget(q_canvas_widget)
        q_main_widget.setLayout(q_widget_l)
        
        self._mx_frame_idx_changed = mx.Event1[int]().dispose_with(self)
        self._mx_frame_idx_clicked = mx.Event1[int]().dispose_with(self)
        
        self._mx_frame_drag_diff = mx.Event1[int]().dispose_with(self)
        
    @property
    def mx_frame_idx_changed(self) -> mx.Event1[int]:
        return self._mx_frame_idx_changed
        
    @property
    def mx_frame_idx_clicked(self) -> mx.Event1[int]:
        return self._mx_frame_idx_clicked
    
    @property
    def mx_frame_drag_diff(self) -> mx.Event1[int]:
        return self._mx_frame_drag_diff
    
        
    def get_frame_idx(self) -> int: return self._frame_idx
    
    def set_frame_count(self, frame_count : int):
        self._update_geometry(new_frame_count=frame_count)
        
    def set_frame_idx(self, frame_idx : int, block_signals = False):
        self._update_geometry(new_frame_idx=frame_idx, block_signals=block_signals)
    
    
    def set_begin_frame_idx(self, idx : int):
        self._update_geometry(new_begin_frame_idx=idx)
        
    def set_end_frame_idx(self, idx : int):
        self._update_geometry(new_end_frame_idx=idx)
        
    def set_view_start_idx(self, start_idx : int):
        ...
        
    def set_view_end_idx(self, end_idx : int):
        ...
        
    def _update_geometry(self,  new_frame_count = None,
                                new_begin_frame_idx = None,
                                new_end_frame_idx = None,
                                new_view_start_idx = None,
                                new_view_end_idx = None,
                                new_frame_idx = None,
                                block_signals = False,
                                resized = False,
                                ):
        rect = self.__q_canvas_widget.rect()
        
        w = rect.width()
        h = rect.height()
        
        begin_frame_idx = self._begin_frame_idx
        end_frame_idx = self._end_frame_idx
        view_start_idx = self._view_start_idx
        view_end_idx = self._view_end_idx
        
        frame_count = self._frame_count
        
        if new_frame_count is not None:
            frame_count = max(0, new_frame_count)
            view_start_idx = begin_frame_idx = 0
            view_end_idx = end_frame_idx = frame_count -1
        
        if new_begin_frame_idx is not None:
            begin_frame_idx = max(0, min(new_begin_frame_idx, frame_count-1))
            
        if new_end_frame_idx is not None:
            end_frame_idx = max(0, min(new_end_frame_idx, frame_count-1))
                
        if new_view_start_idx is not None:
            view_start_idx = new_view_start_idx
        
        if new_view_end_idx is not None:
            view_end_idx = new_view_end_idx
            
        view_start_idx = max(0, min(view_start_idx, frame_count-1))
        view_end_idx = max(0, min(view_end_idx, frame_count-1))
        
        if view_start_idx > view_end_idx:
            view_start_idx = view_end_idx
            
        if view_end_idx < view_start_idx:
            view_end_idx = view_start_idx
            
        frame_idx = self._frame_idx
        if new_frame_idx is not None:
            frame_idx = max(0, min(new_frame_idx, frame_count-1))
        
        if not (view_start_idx <= frame_idx and frame_idx <= view_end_idx):
            view_start_idx, view_end_idx = frame_idx, frame_idx + view_end_idx - view_start_idx

            if view_end_idx > frame_count-1:
                view_start_idx, view_end_idx = (frame_count-1) - (view_end_idx - view_start_idx), frame_count-1
    
        upd = resized
        if self._frame_count != frame_count:
            self._frame_count = frame_count
            upd = True
        
        if self._begin_frame_idx != begin_frame_idx:
            self._begin_frame_idx = begin_frame_idx
            upd = True
            
        if self._end_frame_idx != end_frame_idx:
            self._end_frame_idx = end_frame_idx
            upd = True
                  
        if self._view_start_idx != view_start_idx:
            self._view_start_idx = view_start_idx
            upd = True
        
        if self._view_end_idx != view_end_idx:
            self._view_end_idx = view_end_idx
            upd = True
            
        if self._frame_idx != frame_idx:
            self._frame_idx = frame_idx     
            upd = True
            # if not block_signals:
            #     self._mx_frame_idx_changed.emit(frame_idx)  
                 
        if upd:            
            self._begin_frame_cursor_x = int( w*(begin_frame_idx-view_start_idx)/(view_end_idx-view_start_idx) )
            self._end_frame_cursor_x = int( w*(end_frame_idx-view_start_idx)/(view_end_idx-view_start_idx) )
            
            self._frame_cursor_x = int( w*(frame_idx-view_start_idx)/(view_end_idx-view_start_idx) )
            
            
            self.update()
        
    def _get_frame_by_pos(self, x : int):
        rect = self.__q_canvas_widget.rect()
        w = rect.width()
        return self._view_start_idx + int((x / (w-1))*(self._view_end_idx-self._view_start_idx+1))
        
        
    def _q_canvas_minimumSizeHint(self, widget, super):
        return qt.QSize(24,25)
    
    def _q_canvas_resizeEvent(self, widget, super, ev : qt.QResizeEvent):
        super(ev)
        self._update_geometry(resized=True)
          
    def _q_canvas_mousePressEvent(self, widget, super, ev : qt.QMouseEvent):
        super(ev)
        self._mouse_down_pt = ev.pos()
        self._dragging = False
    
    def _q_canvas_mouseMoveEvent(self, widget, super, ev : qt.QMouseEvent):
        super(ev)
        mouse_pt = ev.pos()
        
        if (mouse_down_pt := self._mouse_down_pt) is not None:
            # Moving pressed
            
            if qt.QLine(mouse_pt, mouse_down_pt).toLineF().length() >= 5:
                if not self._dragging:
                    self._dragging = True
                    self._frame_dragging_delta_f = 0.0
                    print('override')
                    QApplication.instance().set_override_cursor(qt.Qt.CursorShape.SizeHorCursor)
                
            if self._dragging:
                self._frame_dragging_delta_f += (mouse_pt.x() - mouse_down_pt.x()) / 5.0
                
                frame_dragging_delta = int(self._frame_dragging_delta_f)
                if frame_dragging_delta != 0:
                    self._frame_dragging_delta_f -= frame_dragging_delta
                    self._mx_frame_drag_diff.emit(frame_dragging_delta)
                
                QApplication.instance().set_cursor_pos(self.map_to_global(mouse_down_pt))
            
        
    def _q_canvas_mouseReleaseEvent(self, widget, super, ev : qt.QMouseEvent):
        super(ev)
        mouse_pt = ev.pos()
        
        if (mouse_down_pt := self._mouse_down_pt) is not None:
                    
            if self._dragging:
                print('restore')
                QApplication.instance().restore_override_cursor()
            else:            
                idx = self._get_frame_by_pos(mouse_down_pt.x())
                self._mx_frame_idx_clicked.emit(idx)
                
            self._mouse_down_pt = None
        
        # item_id_pt = self._get_idx_from_point(mouse_pt)
        
        # if self._selecting_idx_range is not None and item_id_pt is not None:
        #     self._selecting_idx_range = (self._selecting_idx_range[0], item_id_pt)
        #     self.update()
          
        # if self._selecting_idx_range is not None:
        #     selected_set = self.get_selecting()
            
        #     if self._selecting_un:
        #         self.unselect(selected_set)
        #     else:                
        #         self.select(selected_set)
                
            # self._selecting_idx_range = None
            
    def _q_canvas_leaveEvent(self, widget : qt.QWidget, super, ev : qt.QEvent):
        super(ev)
        
               
    def _q_canvas_paintEvent(self, widget : qt.QWidget, super, ev : qt.QPaintEvent):
        qp = self._qp
        qp.begin(widget)
        
        rect = widget.rect()
        
        w = rect.width()
        h = rect.height()
        
        style = QStyle.instance()
            
        qp.setPen( style.get_text_color() )        
        qp.drawLine(0, h//2, w-1, h//2)
        
        frame_count = self._frame_count
        if frame_count != 0:
            #frame_idx = self._frame_idx
            
            qp.setPen(qt.QPen(StyleColor.green, 2))
            qp.drawLine(self._begin_frame_cursor_x, 0, self._begin_frame_cursor_x, h-1)
            qp.drawLine(self._end_frame_cursor_x, 0, self._end_frame_cursor_x, h-1)
            
            qp.setPen(qt.QPen(style.get_text_color(), 2))
            qp.drawLine(self._frame_cursor_x, 0, self._frame_cursor_x, h-1)
            
        qp.end()