from .. import qt

class QListWidgetItem:
    Flag = qt.Qt.ItemFlag
    CheckState = qt.Qt.CheckState
    
    def __init__(self, q_listwidget_item = None):
        if q_listwidget_item is None:
            q_listwidget_item = qt.QListWidgetItem()
        if not isinstance(q_listwidget_item, qt.QListWidgetItem):
            raise ValueError('q_listwidget_item must be an instance of QListWidgetItem')
        self.__q_listwidget_item = q_listwidget_item
        
        
    def _get_q_listwidget_item(self) -> qt.QListWidgetItem: return self.__q_listwidget_item
        
     
    def set_text(self, text : str):
        self._get_q_listwidget_item().setText(text)
        return self
     
    def set_flags(self, flags : Flag):
        self._get_q_listwidget_item().setFlags(flags)
        return self
        
    def add_flags(self, flags : Flag):
        self._get_q_listwidget_item().setFlags(self._get_q_listwidget_item().flags() | flags)
        return self    
        
    def set_check_state(self, state : CheckState):
        self._get_q_listwidget_item().setCheckState(state)
        return self
        
                
        
            
         