from .. import qt, mx
from .QWidget import QWidget
from .QListWidgetItem import QListWidgetItem

class QListWidget(QWidget):
    def __init__(self, q_listwidget=None):
        if q_listwidget is None:
            q_listwidget = qt.QListWidget()
        if not isinstance(q_listwidget, qt.QListWidget):
            raise ValueError('q_listwidget must be an instance of QListWidget')
         
        self.__q_listwidget = q_listwidget
        super().__init__(q_widget=q_listwidget)
        
        self._mx_item_changed = mx.Event1[QListWidgetItem]()
        
        q_listwidget.itemChanged.connect(lambda item: print('changed', item)) #self._mx_item_changed.emit(item)
                
        #q_listwidget.currentIndexChanged.connect(self._on_currentIndexChanged)
        #self._mx_current_index_changed = mx.Event1[Union[int, None]]().dispose_with(self)
        
    def get_q_listwidget(self): return self.__q_listwidget
     
    @property
    def mx_item_changed(self) -> mx.Event1[QListWidgetItem]:
        return self._mx_item_changed
        

    def add_item(self, label : str) -> QListWidgetItem:
        w = self._get_q_listwidget()
        w.addItem(label)
        
        
        item = w.item(w.count()-1)
        
        #w.setItemWidget(item, qt.QLabel('qwe'))
        
        #w.update(w.indexFromItem(item))
        
        return QListWidgetItem(q_listwidget_item=item)
        
        self._get_q_listwidget().addItem(item._get_q_listwidget_item())
        return self
          