from xlib import mx, qx
import numpy as np
from .DatasetEditor import DatasetEditor
from RxDataset import RxDataset, RxDatasetGUI, DImage, DFace
from RxMediaSource import RxMediaSourceGUI
import random
        
class DatasetEditorGUIApp(qx.QApplication):
    def __init__(self, backend : DatasetEditor, ui_settings_path = None):
        super().__init__(app_name='Dataset Editor', ui_settings_path=ui_settings_path)
        self._backend = backend
    
    
        
        ms_gui = self._ms_gui = RxMediaSourceGUI(backend.mx_media_source)
        
        #ui state from file
        
        gui_wnd = self._gui_wnd = (qx.QWindow().set_object_name('DatasetEditor')
                                               .set_parent(self)
                                               .set_title('Dataset Editor'))
        gui_wnd.mx_close.listen(lambda: self.quit()).dispose_with(gui_wnd)
        
        
        # with qx.def_size(qx.ESize.S4), qx.def_font():
        
        MENU_APP = qx.LString().add('en', 'App').add('ru', 'Приложение') 
        MENU_LANGUAGE = qx.LString().add('en', 'Language').add('ru', 'Язык') 
        MENU_FILE_QUIT = qx.LString().add('en', 'Quit').add('ru', 'Выход') 
        
        
        # load_menu = (qx.QMenuRxMenu(backend.mx_load_menu)
        #                 #.set_parent(gui_wnd)
        #                 .set_font(qx.QFont.from_db(qx.EFontDB.FixedWidth, qx.ESize.M))
        #                 .set_title('we')    
        #                 #.hide()
        #             ).dispose_with(gui_wnd)
        
        
        # line_edit = (qx.QLineEditRxTextState(backend.mx_dataset_name)
        #                 .set_font(qx.QFont.from_db(qx.EFontDB.FixedWidth, qx.ESize.M))
        #                 .set_placeholder_text('Enter name to open existing dataset or create new')
        #              )
        #line_edit.mx_editing_finished.listen(lambda: print('finished'))

            
            
        #self._con_load_menu, self._open_dataset_signal.on_signal, parent=self._gui_wnd
 
        #mx_dataset_gui_holder = self._mx_dataset_gui_holder = qx.QVBoxLayout()
        
        #qx.QIcon.from_ion_icon(qx.EIonIcon.)
        
        #q_mx_dataset_pathdlg = qx.QMxPathState(backend.mx_dataset_pathdlg)
        
        gui_wnd.add_widgets(qx.QMenuBar()
                                .add_menus( qx.QMenu().set_title(MENU_APP).add_actions( 
                                                qx.QAction().set_text(MENU_FILE_QUIT).inline(lambda act: act.mx_triggered.listen(lambda: self.quit()).dispose_with(act)), ),                                   
                                            
                                            qx.QMenu().set_title(MENU_LANGUAGE).add_actions(
                                                qx.QAction().set_text('English').inline(lambda act: act.mx_triggered.listen(lambda: self.set_language('en')).dispose_with(act)),
                                                qx.QAction().set_text('Русский').inline(lambda act: act.mx_triggered.listen(lambda: self.set_language('ru')).dispose_with(act)), ),
                                ),
                                
                            
                            qx.QSplitter(vertical=True).add_widgets(
                                ms_gui, 
                                # qx.QSplitter(vertical=False).add_widgets(
                                #     qx.QVBoxLayout().add_widgets(
                                        
                                #         # qx.QHBoxLayout().add_widgets(
                                #         #         (qx.QPushButton()   .set_icon( qx.QIcon.from_ion_icon(qx.EIonIcon.close_outline, qx.QColorDB.lightgray) )
                                #         #                             .inline( lambda btn: btn.mx_clicked.listen(lambda: backend.mx_dataset_name.set(None)).dispose_with(btn)  )
                                #         #                             .h_compact() ),
                                                                    
                                #         #         (qx.QPushButton()   .set_icon( qx.QIcon.from_ion_icon(qx.EIonIcon.open_outline, qx.QColorDB.lightgray))
                                #         #                             .set_tooltip('Open dataset')
                                #         #                             .inline(lambda btn: btn.mx_clicked.listen(lambda: load_menu.show()).dispose_with(btn)  )
                                #         #                             .h_compact() ),                                                
                                #         #         line_edit,
                                #         #     ).v_compact(),
                                        
                                #         q_mx_dataset_pathdlg,
                                        
                                #         mx_dataset_gui_holder,
                                    
                                #         ),
                                        
                                #     #qx.QLabel().set_text('asd'),
                                #     qx.QVBoxLayout().add_widgets(
                                #             qx.QLabel().set_text('Info').v_compact(),
                                #             qx.QSpacer(),
                                #         )
                                # ),
                                
                                # qx.QLabel().set_text('XSeg Editor').v_compact()
                                    
                                    #
                            )
                            )
        
    #     backend.mx_dataset.reflect(self._on_backent_mx_dataset).dispose_with(self)
      
    # def _on_backent_mx_dataset(self, new_dataset : RxDataset):
    #     holder = self._mx_dataset_gui_holder
    #     holder.dispose_childs()
    #     if new_dataset is not None:
    #         #new_dataset.mx_initialized.reflect(lambda i:  ).dispose_with()
            
    #         # if not new_dataset.mx_closed.value:
    #         #     btn_add = qx.QPushButton().set_text('add face')
    #         #     btn_add.mx_clicked.listen(self._on_btn_add)
    #         #     holder.add_widgets( btn_add.v_compact() )
                
    #         holder.add_widgets( RxDatasetGUI(new_dataset) )
    
    def _on_btn_add(self):
        print('_on_btn_add')
        
        dataset = self._backend.mx_dataset.value
        if dataset is not None:
            d_face = DFace()
            #d_face.source_name = f'{random.randint(0, 400000)}.jpg'
            
            # d_image = DImage()
            # d_image.name = 'some image'
            # np_image = (np.indices( (128,128,1) ).sum(axis=0) % 2).astype(np.float32)
            # d_image.np_image = np_image
            
            dataset.add_face(d_face)
            
            
            #import code
            #code.interact(local=dict(globals(), **locals()))
    
        
        #qx.Shortcut(gui_wnd).set_key('Ctrl+P')
        
           
        
        
            
        # gui_wnd = self._gui_wnd = qx.QWindow(name='DatasetEditor', parent=self._gui_root).set_title('Dataset Editor')
        
        # open_data_btn = qx.QPushButton(self._open_dataset_signal).set_image(qx.get_image(qx.EIonIcon.open_outline)).set_tooltip('Open dataset')
        # close_dataset_btn = qx.QPushButton(self._close_dataset_signal).set_image(qx.get_image(qx.EIonIcon.close_outline)).set_tooltip('Close dataset')
    
        # #picture_view = self._picture_view = XPictureListWidget(on_get_item_data=self._on_picture_view_get_item_data)
        # #picture_view.get_image=self._on_picture_view_get_image
        
        
        # gui_wnd.add_widgets([
        #     qx.LVStack().add_widgets([
                
        #         qx.QHBoxLayout().add_widgets([
        #             close_dataset_btn.h_compact(),
        #             open_data_btn.h_compact(),
                    
        #             (qx.WLineEdit(self._dataset_name)
        #                 .set_font(qx.get_font(qx.EFontDB.FixedWidth))
        #                 .set_placeholder_text('Enter name to open existing dataset or create new')
        #              )
                    
        #             ,
        #             ])
        #         ]).v_compact() ,
                
                
        #         #picture_view
        #     ])
        
        
        
    