from __future__ import annotations

from pathlib import Path
from typing import Callable, Dict, Union

import numpy as np

from RxDataset import DFace, RxDataset
from RxMediaSource import RxMediaSource
from xlib import ax
from xlib import path as ext_path
from xlib import mx


class DatasetEditor(mx.Disposable):
    def __init__(self,  workspace_path : Path):
        super().__init__()
        self._workspace_path = workspace_path
        
        self._tg = ax.TaskGroup()
        
        self._mx_media_source = RxMediaSource().dispose_with(self)
        

        self._mx_dataset_pathdlg = mx.PathState(   config=mx.PathState.Config(allow_open=True, allow_new=True, extensions=['ds'], desc='Dataset'),
                                                    on_open=self._dataset_pathdlg_open,
                                                    on_new=self._dataset_pathdlg_new,
                                                    on_close=self._dataset_pathdlg_close,
                                                    ).dispose_with(self)
        
        self._mx_dataset = mx.FValue[ Union[RxDataset, None] ](None, filter=self._dataset_filter).dispose_with(self)
        

        
    def dispose(self):
        self._mx_dataset_pathdlg.close()
        super().dispose()
            
    @property
    def mx_media_source(self) -> RxMediaSource:
        return self._mx_media_source
        
    @property
    def mx_dataset_pathdlg(self) -> mx.PathState:
        """"""
        return self._mx_dataset_pathdlg
         
    @property
    def mx_dataset(self) -> mx.FValue[ Union[RxDataset, None] ]:
        """Reflects current RxDataset class. To open or close dataset use .mx_dataset_pathdlg"""
        return self._mx_dataset
     
      
    def _dataset_filter(self, new_dataset : Union[RxDataset, None], dataset : Union[RxDataset, None]):
        if dataset is not None:
            dataset.dispose()
        return new_dataset
        
    def _dataset_pathdlg_open(self, path : Path) -> bool:
        self._mx_dataset.set(RxDataset(path))
        return True
        
    def _dataset_pathdlg_new(self, path : Path) -> bool:
        self._mx_dataset.set(RxDataset(path, create_new=True))
        return True
           
    def _dataset_pathdlg_close(self):
        self._mx_dataset.set(None)       
        
    def _on_video_player_mx_frame(self, frame : np.ndarray):
        ...
        #if frame is not None:
        #    print('_on_video_player_mx_frame', frame.shape)
        
    def __repr__(self): return self.__str__()
    def __str__(self): return f"{super().__str__()}"
        

        
class StatePath:
    def __init__(self, path):
        self.path = path
        
    def __eq__(self, o):
        return self.path == o.path
        
    def __str__(self):
        return f"[{ext_path.creation_date(self.path).strftime('%Y.%m.%d %H:%M:%S')}] [{ self.path.stat().st_size // (1024**2) }Mb] {self.path.name} "
    

# self._mx_load_menu = mx.Menu[StatePath](lambda: [  StatePath(filepath) for filepath in ext_path.get_files_paths(self._workspace_path) 
#                                                             if filepath.suffix == '.ds'],
#                              control=lambda choice,: self._mx_dataset_name.set(choice.path.stem)).dispose_with(self)

#vp = VideoPlayer( task_on_frame_idx)
#vp.

#import code
#code.interact(local=dict(globals(), **locals()))
# class QPictureListWidget(QWidget):
#     def __init__(self):
#         self._item_size = 128
#         self._item_count = 0
#         self._qp = QPainter()
#         self._scroll_y = 0
        
#     def set_item_count(self, item_count : int):
#         self._item_count = item_count
#         self.update()
        
#     def paintEvent(self, ev : QPaintEvent):
#         super().paintEvent(ev)
        
#         qp = self._qp
#         qp.begin(self)
        
#         rect = self.rect()
#         width, height = rect.width(), rect.height()
        
        
        
        
#         qp.end()    
