import torch

class AdaBelief(torch.optim.Optimizer):
    def __init__(self, params, betas=(0.9, 0.999), eps=1e-16,):

        defaults = dict( betas=betas, eps=eps)
        super(AdaBelief, self).__init__(params, defaults)
    
    # def reset(self):
    #     for group in self.param_groups:
    #         for p in group['params']:
    #             state = self.state[p]
    #             state['m_t'] = torch.zeros_like(p.data,memory_format=torch.preserve_format)
    #             state['v_t'] = torch.zeros_like(p.data,memory_format=torch.preserve_format)
                                
    def step(self, iteration=None, lr=1e-3, lr_dropout : float = 0.0):
        
        for group in self.param_groups:
            for p in group['params']:
                if p.grad is None:
                    continue

                grad = p.grad.data

                beta1, beta2 = group['betas']

                state = self.state[p]
                if len(state) == 0:
                    state['m_t'] = torch.zeros_like(p.data, memory_format=torch.preserve_format)
                    state['v_t'] = torch.zeros_like(p.data, memory_format=torch.preserve_format)
            
                m_t, v_t = state['m_t'], state['v_t']
                m_t.mul_(beta1).add_(  grad           , alpha=1 - beta1)
                v_t.mul_(beta2).add_( (grad - m_t)**2 , alpha=1 - beta2)

                v_diff = (-lr * m_t).div_( v_t.sqrt().add_(group['eps']) )

                if lr_dropout is None:
                    lr_dropout = group['lr_dropout']

                if lr_dropout != 0.0:
                    lrd = torch.full(p.data.size(), 1.0-lr_dropout, device=p.device)
                    torch.bernoulli(lrd, out=lrd)
    
                    v_diff *= lrd

                p.data.add_(v_diff)
