from typing import Callable

import torch

def init_and_load(model_creation_func : Callable[ [], torch.nn.Module], state_dict : dict = None) -> torch.nn.Module:
    """
    instantiate Module and try to load state from dict and key.
    If something goes wrong during loading, return only pure instantiated model
    """
    model = model_creation_func()
    try:
        if state_dict is not None:
            model.load_state_dict(state_dict)
            return model
    except:
        # Something goes wrong. 
        # We need to instantiate again, because weights may be partial loaded that is unacceptable.
        model = None # Delete reference in order to free RAM before reinstantiation
        model = model_creation_func()
    return model