import torch
import numpy as np

_np_dtype_from_torch = {
    torch.float32 : np.float32,
    torch.float64 : np.float64,
    torch.double : np.double,
    torch.float16 : np.float16,
    torch.half : np.half,
    torch.uint8 : np.uint8,
    torch.int8 : np.int8,
    torch.int16 : np.int16,
    torch.short : np.short,
    torch.int32 : np.int32,
    torch.int64 : np.int64, }
    
def get_np_dtype_from_torch(dtype : torch.dtype) -> np.dtype:
    return _np_dtype_from_torch[dtype]