import typing as _typing


class dotdict(dict):
    """dot.notation access to dictionary attributes"""
    __getattr__ = dict.get
    __setattr__ = dict.__setitem__
    __delattr__ = dict.__delitem__

def list_elem_added(l : _typing.List, elem, no_dup : bool = False):
    l = l.copy()
    if not no_dup or elem not in l:
        l.append(elem)
    return l
    
def list_elem_removed(l : _typing.List, elem, silent : bool = False):
    l = l.copy()
    if not silent or elem in l:
        l.remove(elem)
    return l