import numpy as np
import cv2
from ..ImageProcessor import ImageProcessor

from ...hash import LSHash64

def perceptual64(img : np.ndarray) -> LSHash64:
    """
    Image perceptual local-sensitive 64-bit hash 
    
    based on http://www.hackerfactor.com/blog/index.php?/archives/432-Looks-Like-It.html
    
    returns LSHash64
    """
    hash_size, highfreq_factor = 8, 4
    
    img = ImageProcessor(img).ch(1).resize( (hash_size * highfreq_factor, hash_size * highfreq_factor)  ) \
                                     .to_ufloat32().get_image('HW')
    dct = cv2.dct(img)
    
    dct_low_freq = dct[:hash_size, :hash_size]
    bits = ( dct_low_freq > np.median(dct_low_freq) ).reshape( (hash_size*hash_size,)).astype(np.uint64)
    bits = bits << np.arange(len(bits), dtype=np.uint64)    
    
    return LSHash64(bits.sum())
    