import numpy as np

from ..AShape import AShape
from ..HKernel import HKernel as HK
from ..info import InfoConv1D


class AdaDCT1D:
    def __init__(self, N, IC, IW, OC, kernel_size, stride, dilation, padding, i_dtype : np.dtype, o_dtype : np.dtype = None):
        info = InfoConv1D(IW, kernel_size, stride, dilation, padding)
        
        i_shape = (N,IC,IW)
        o_shape = self._o_shape = AShape((N,OC,info.OW))
        
        self._forward_krn_text = f"""
#define STRIDE {stride}
#define DILATION {dilation}
#define PADL {info.PADL}

{HK.define_tensor('I', i_shape, i_dtype)}
{HK.define_tensor('O', o_shape, o_dtype)}

extern "C" __global__
void {self.get_forward_kernel_name()}(O_PTR_TYPE* O_PTR_NAME, const I_PTR_TYPE* I_PTR_NAME) 
{{
    size_t gid = blockIdx.x;
    {HK.decompose_idx_to_axes_idxs('gid', 'O', o_shape.ndim)}
    
    float v = 0.0;
    
    
    O_GLOBAL_STORE(gid, (O_TYPE) v);
}}
"""
        print(self._forward_krn_text)
        
        #import code
        #code.interact(local=dict(globals(), **locals()))
        
    def get_output_shape(self) -> AShape: return self._o_shape
    def get_forward_kernel(self) -> str: return self._forward_krn_text
    def get_forward_kernel_name(self) -> str: return 'AdaDCT1D_fwd'
    def get_backward_kernel(self) -> str: return self._backward_krn_text
