
from datetime import datetime
from typing import Union


class Timeline:
    """
    """

    def __init__(self, frame_idx : int, frame_count : int, fps : float = 0):
        self.frame_count = frame_count
        self.fps = fps
        self.is_autorewind = False
        self.playing = False
        self.frame_idx = frame_idx
        self.begin_frame_idx = 0
        self.end_frame_idx = frame_count-1
       
        self.frame_ts : float = None
    
    
    def process(self,   req_begin_frame_idx : int = None,
                        req_end_frame_idx : int = None,
                        req_fps : float = None,
                        req_is_autorewind : bool = None,
                        req_playing : bool = None,
                        req_frame_idx : int = None,
                ) -> 'Timeline.ProcessResult':
        """Process next tick"""
        
        frame_count = self.frame_count
        begin_frame_idx = max(0, min(frame_count-1, 
                            req_begin_frame_idx if req_begin_frame_idx is not None else self.begin_frame_idx ))
        
        end_frame_idx   = max(0, min(frame_count-1, 
                            req_end_frame_idx if req_end_frame_idx is not None else self.end_frame_idx))
           
        if begin_frame_idx > end_frame_idx:
            begin_frame_idx = end_frame_idx
            
        if end_frame_idx < begin_frame_idx:
            end_frame_idx = begin_frame_idx
                            
        fps             = req_fps if req_fps is not None else self.fps
        is_autorewind   = req_is_autorewind if req_is_autorewind is not None else self.is_autorewind
        playing         = self.playing
        
        frame_ts = self.frame_ts
             
                
        frame_idx = self.frame_idx
        if req_frame_idx is not None:
            # User request seek
            frame_idx = req_frame_idx
            frame_ts = datetime.now().timestamp()
            playing = False
        else:
            # User not requested to seek frame_idx
            if playing:          
                # Calc frame_idx in playing
                if fps != 0:
                    # Fps set. frame_idx by time
                    diff_frames = int( (datetime.now().timestamp() - frame_ts) / (1.0/fps) )
                    if diff_frames != 0:
                        frame_idx += diff_frames
                        frame_ts += diff_frames * (1.0/fps)
                else:
                    # Fps not set. frame_idx is just next idx
                    frame_idx += 1
                    frame_ts = datetime.now().timestamp()

                
        if self.frame_idx != frame_idx:
            # frame_idx changed, filter it
            f_start_idx, f_end_idx = (begin_frame_idx, end_frame_idx) if playing else (0, frame_count-1)
                
            if is_autorewind:
                frame_idx = f_start_idx + frame_idx % (f_start_idx-f_end_idx)
            else:
                playing = playing and frame_idx >= f_start_idx and frame_idx <= f_end_idx
                frame_idx = max(f_start_idx, min(f_end_idx, frame_idx) )
            
    
        # Update state and return ProcessResult
        st = Timeline.ProcessResult()
                
        if req_playing is not None:
            playing = req_playing
            if req_playing:
                if frame_idx < begin_frame_idx or frame_idx >= end_frame_idx:
                    frame_idx = begin_frame_idx
            
        if self.playing != playing:
            self.playing = st.new_is_playing = playing
                
        if self.frame_idx != frame_idx or req_frame_idx is not None or req_playing == True:
            self.frame_idx = st.new_frame_idx = frame_idx
        
        if self.frame_ts != frame_ts:
            self.frame_ts = frame_ts    
            
        if self.is_autorewind != is_autorewind:
            self.is_autorewind = is_autorewind
        
        if self.fps != fps or req_fps is not None:
            self.fps = fps
            
        if self.begin_frame_idx != begin_frame_idx:
            self.begin_frame_idx = st.new_begin_frame_idx = begin_frame_idx
            
        if self.end_frame_idx != end_frame_idx:
            self.end_frame_idx = st.new_end_frame_idx = end_frame_idx

        return st
        
    class ProcessResult:
        def __init__(self):
            self.new_begin_frame_idx = None
            self.new_end_frame_idx = None
            self.new_is_playing = None
            self.new_frame_idx = None
    
# from datetime import datetime
# from typing import Union


# class Timeline:
#     """
#     """

#     def __init__(self, frame_idx : int, frame_count : int, fps : Union[float, None] = None):
#         self.frame_count = frame_count
#         self.fps = fps
#         self.is_autorewind = False
#         self.playing = False
#         self.frame_idx = frame_idx
#         self.frame_ts : float = None
    
    
#     def process(self,   new_playing : bool = None,
#                         new_frame_idx : int = None,
#                         new_fps : Union[float, None] = None,
#                         new_is_autorewind : bool = None,
#                 ) -> 'Timeline.ProcessResult':
#         """Process next tick"""
        
#         frame_count = self.frame_count
#         fps         = self.fps
#         is_autorewind = self.is_autorewind
#         playing     = self.playing
#         frame_idx   = self.frame_idx
#         frame_ts    = self.frame_ts
        
#         if frame_count == 0:#
#             playing = False
        
#         if playing:          
#             if fps is not None:
#                 # Fps set. Calc frame_idx by time
#                 diff_frames = int( (datetime.now().timestamp() - frame_ts) / (1.0/fps) )
#                 if diff_frames != 0:
#                     frame_idx += diff_frames
#                     frame_ts += diff_frames * (1.0/fps)
#             else:
#                 # Fps not set. frame_idx is just next idx
#                 frame_idx += 1
#                 frame_ts = datetime.now().timestamp()

#         # Filter frame_idx
#         if is_autorewind:
#             frame_idx %= frame_count
#         else:
#             if frame_idx < 0:
#                 frame_idx = 0
#                 playing = False
#             elif frame_idx > frame_count-1:
#                 frame_idx = frame_count-1
#                 playing = False
    
#         # Update state and return ProcessResult
#         st = Timeline.ProcessResult()
            
        
            
#         if self.frame_idx != frame_idx:
#             self.frame_idx = st.new_frame_idx = frame_idx
                
        
#         if new_is_autorewind is not None:
#             is_autorewind = new_is_autorewind
#         if self.is_autorewind != is_autorewind:
#             self.is_autorewind = is_autorewind
        
#         if new_fps is not None:
#             fps = new_fps
#         if self.fps != fps:
#             self.fps = fps
            
#         if self.frame_ts != frame_ts:
#             self.frame_ts = frame_ts
            
            
#         if new_is_autorewind is None:
#             new_is_autorewind = is_autorewind
            
        
#         # if new_playing is None:
#         #     new_playing = playing
            
#         # if new_playing != playing:
#         #     if new_playing and frame_count == 0:
#         #         new_playing = False
                    
#         if self.playing != playing:
#             self.playing = st.new_is_playing = playing
        
#         if new_playing is not None:
#             self.playing = new_playing
            
#         if new_frame_idx is not None:
#             # User request seek
#             self.frame_idx = new_frame_idx
#             self.frame_ts = datetime.now().timestamp()
        
#         return st
        
#     class ProcessResult:
#         def __init__(self):
#             self.new_is_playing = None
#             self.new_frame_idx = None
    
    
    

# from datetime import datetime
# from typing import Union


# class Timeline:
#     """
#     """

#     def __init__(self, frame_idx : int, frame_count : int, fps : Union[float, None] = None):
#         self.frame_count = frame_count
#         self.fps = fps
#         self.is_autorewind = False
#         self.playing = False
#         self.frame_idx = frame_idx
#         self.frame_ts : float = None
    
    
#     def process(self,   new_playing : bool = None,
#                         new_frame_idx : int = None,
#                         new_fps : Union[float, None] = None,
#                         new_is_autorewind : bool = None,
#                 ) -> 'Timeline.ProcessResult':
#         """Process next tick"""
        
#         frame_count = self.frame_count
#         fps = self.fps
#         is_autorewind = self.is_autorewind
#         playing = self.playing
#         frame_idx = self.frame_idx
#         frame_ts = self.frame_ts
        
#         if new_fps is None:
#             new_fps = fps
            
#         if new_is_autorewind is None:
#             new_is_autorewind = is_autorewind
        
#         if new_playing is None:
#             new_playing = playing
            
#         if frame_count == 0:
#             new_playing = False
        
#         if new_frame_idx is not None:
#             # User request seek
#             new_frame_ts = datetime.now().timestamp()
#         else:
#             # User not requested to seek new_frame_idx
#             if new_playing:          
#                 # Calc new_frame_idx in playing
#                 if fps is not None:
#                     # Fps set. new_frame_idx by time
#                     diff_frames = int( (datetime.now().timestamp() - frame_ts) / (1.0/new_fps) )
#                     if diff_frames != 0:
#                         new_frame_idx = frame_idx + diff_frames
#                         new_frame_ts = frame_ts + diff_frames * (1.0/new_fps)
#                 else:
#                     # Fps not set. new_frame_idx is just next idx
#                     new_frame_idx = frame_idx + 1
#                     new_frame_ts = datetime.now().timestamp()
#             else:
#                 # Not playing, keep same
#                 new_frame_idx = frame_idx
#                 new_frame_ts = frame_ts
                
#         # Filter new_frame_idx
#         if new_is_autorewind:
#             new_frame_idx %= frame_count
#         else:
#             if new_frame_idx < 0:
#                 new_frame_idx = 0
#                 new_playing = False
#             elif new_frame_idx > frame_count-1:
#                 new_frame_idx = frame_count-1
#                 new_playing = False
    
#         # Update state and return ProcessResult
#         st = Timeline.ProcessResult()
        
#         if new_frame_idx != frame_idx:
#             self.frame_idx = st.new_frame_idx = new_frame_idx
              
#         if new_is_autorewind != is_autorewind:
#             self.is_autorewind = new_is_autorewind
        
#         if new_fps != fps:
#             self.fps = new_fps
                
#         if new_frame_idx != frame_idx:
#             self.frame_idx = st.new_frame_idx = new_frame_idx
            
#         if new_frame_ts != frame_ts:
#             self.frame_ts = new_frame_ts
            
#         if new_playing != playing:
#             self.playing = st.new_is_playing = new_playing

#         return st
        
#     class ProcessResult:
#         def __init__(self):
#             self.new_is_playing = None
#             self.new_frame_idx = None
    