from typing import Union
from .RxTimeline import RxTimeline
from xlib import qt, qx, ax, mx
import numpy as np


        
class RxTimelineGUI(qx.QVBoxLayout):
    def __init__(self, tl : RxTimeline):
        super().__init__()
        self._tl = tl
    
        q_tl = self._q_tl = qx.QTimelineWidget()
        q_tl.set_frame_count(tl.mx_frame_count.value)
        #q_tl.mx_frame_idx_changed.listen(self._q_tl_frame_idx_changed).dispose_with(self)
        q_tl.mx_frame_idx_clicked.listen(lambda idx: tl.mx_frame_idx.set(idx)).dispose_with(self)
        q_tl.mx_frame_drag_diff.listen(lambda diff: tl.mx_frame_idx.set(tl.mx_frame_idx.value+diff)).dispose_with(self)
        
        tl.mx_begin_frame_idx.reflect(lambda idx: q_tl.set_begin_frame_idx(idx)).dispose_with(self)
        tl.mx_end_frame_idx.reflect(lambda idx: q_tl.set_end_frame_idx(idx)).dispose_with(self)
        
        tl.mx_frame_idx.reflect(self._on_tl_frame_idx).dispose_with(self)
    
        play_pause_btn = qx.QOnOffPushButtonRxFlagState(tl.mx_playing)
        play_pause_btn.on_button.set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.pause_circle_outline, qx.QColorDB.red))
        play_pause_btn.off_button.set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_circle_outline, qx.QColorDB.red))
        
        begin_frame_btn = qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_skip_back_circle_outline, qx.QColorDB.greenyellow))
        begin_frame_btn.mx_clicked.listen(lambda: tl.mx_begin_frame_idx.set(tl.mx_frame_idx.value) )
        
        end_frame_btn = qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_skip_forward_circle_outline, qx.QColorDB.green))
        end_frame_btn.mx_clicked.listen(lambda: tl.mx_end_frame_idx.set(tl.mx_frame_idx.value) )
        
        self.add_widgets(
            qx.QHBoxLayout().add_widgets(
                qx.QSpacer().h_expand(),
                
                begin_frame_btn,
                play_pause_btn,
                end_frame_btn,
                # qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_skip_back_circle_outline, qx.QColorDB.red)),
                
                # qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_back_circle_outline, qx.QColorDB.red)),
                
                # qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_circle_outline, qx.QColorDB.red)),
                # qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.pause_circle_outline, qx.QColorDB.red)),
        
                # qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_forward_circle_outline, qx.QColorDB.red)),
                # qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_skip_forward_circle_outline, qx.QColorDB.red)),
                
                qx.QSpacer().h_expand(),
            ).v_compact(),
            q_tl,
            
            qx.QHBoxLayout().add_widgets(
                qx.QSpacer().h_expand(),
                qx.QDoubleSpinBoxRxNumberState(tl.mx_frame_idx),
                qx.QSpacer().h_expand(),
            ).v_compact(),
        ).v_compact()
        
        # vp.mx_error.listen(self._on_vp_mx_error, emit_current=True).dispose_with(self)
        # vp.mx_media_pathdlg.mx_path.listen(self._on_vp_mx_media_path, emit_current=True).dispose_with(self)
        # vp.mx_frame.listen(self._on_vp_mx_frame, emit_current=True).dispose_with(self)
        # #qx.QLineEditRxTextState
        

    def _on_tl_frame_idx(self, frame_idx):
        self._q_tl.set_frame_idx(frame_idx)#, block_signals=True)
        
    
    def _q_tl_frame_idx_clicked(self, frame_idx):
        self._tl.mx_frame_idx.set(frame_idx)
        
    # def _q_tl_frame_idx_changed(self, frame_idx):
    #     self._tl.mx_frame_idx.set(frame_idx)
        
        
    
    # def _on_vp_mx_error(self, error : Union[str, None]):
    #     self._error_holder.dispose_childs()
        
    #     if error is not None:
    #         self._error_holder.add_widgets(
    #             (qx.QLabel()                
    #                     .set_text(f'Error: {error}')
    #                     .set_text_interaction_flags(qx.QLabel.TextInteractionFlag.TextSelectableByMouse)
    #                     .set_word_wrap(True).set_font(qx.QFont.from_db(qx.EFontDB.FixedWidth))
    #                     .set_align(qx.Align.Center)
    #                 ),
    #         )
    #     else:
    #         self._error_holder.add_widgets( qx.QSpacer() )

    # def _on_vp_mx_media_path(self, path):
    #     print('_on_vp_mx_media_path', path)
    #     if path is not None:
    #         mx_tl = self._vp.mx_timeline
            
    #         #mx_tl.mx_frame_idx
            
    #         self._q_fitted_pixmap_widget = qx.QPixmapWidget()
            
    #         play_pause_btn = qx.QOnOffPushButtonRxFlagState(mx_tl.mx_playing)
    #         play_pause_btn.on_button.set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.pause_circle_outline, qx.QColorDB.red))
    #         play_pause_btn.off_button.set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_circle_outline, qx.QColorDB.red))
            
    #         self._error_holder.dispose_childs()
    #         self._error_holder.hide()
            
    #         self._canvas_holder.add_widgets(
    #             #qx.QSpacer().v_expand(),
                
    #             self._q_fitted_pixmap_widget,
                
    #             qx.QHBoxLayout().add_widgets(
    #                 qx.QSpacer().h_expand(),
                    
    #                 play_pause_btn,
    #                 # qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_skip_back_circle_outline, qx.QColorDB.red)),
                    
    #                 # qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_back_circle_outline, qx.QColorDB.red)),
                    
    #                 # qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_circle_outline, qx.QColorDB.red)),
    #                 # qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.pause_circle_outline, qx.QColorDB.red)),
            
    #                 # qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_forward_circle_outline, qx.QColorDB.red)),
    #                 # qx.QPushButton().set_icon(qx.QIcon.from_ion_icon(qx.EIonIcon.play_skip_forward_circle_outline, qx.QColorDB.red)),
                    
    #                 qx.QSpacer().h_expand(),
    #             ).v_compact(),
    #         ).show()
            
            
    #     else:
    #         self._canvas_holder.dispose_childs()
    #         self._canvas_holder.hide()
            
    #         self._error_holder.show()
            
    # def _on_vp_mx_frame(self, frame : Union[np.ndarray, None]):
    #     if frame is not None:
    #         self._q_fitted_pixmap_widget.set_pixmap(q_pixmap)