from datetime import datetime
from typing import Generator, Iterable, List, Sequence, Set, Union

from xlib import ax, mx

from .Timeline import Timeline


class RxTimeline(mx.Disposable):
    """```
        Universal horizontal timeline for any purposes.
    ```"""
        
    def __init__(self,  frame_count : int,
                        task_on_frame_idx : ax.Task[int] = None,
                        ):
        """```
            
            task_on_frame_idx   
        ```"""
        super().__init__()
        self._task_on_frame_idx = task_on_frame_idx
        
        self._tl = Timeline(0, frame_count=frame_count)
   
        self._mx_frame_count = mx.Number(frame_count-1, mx.Number.Config(min=frame_count-1, max=frame_count-1, read_only=True)).dispose_with(self)
        self._mx_begin_frame_idx = mx.Number(0, mx.Number.Config(min=0, max=frame_count-1)).dispose_with(self)
        self._mx_end_frame_idx = mx.Number(frame_count-1, mx.Number.Config(min=0, max=frame_count-1)).dispose_with(self)
        self._mx_playing = mx.Flag(False).dispose_with(self)
        self._mx_frame_idx = mx.Number(0, mx.Number.Config(min=0, max=frame_count-1)).dispose_with(self)
        
        self._tg = ax.TaskGroup()
        self._main_task()
        
    def dispose(self) -> None:
        super().dispose()
        self._tg.dispose()
    
    @property
    def mx_frame_count(self) -> mx.Number:
        """Readonly frame count."""
        return self._mx_frame_count
        
    @property
    def mx_begin_frame_idx(self) -> mx.Number:
        """Begin frame idx."""
        return self._mx_begin_frame_idx
            
    @property
    def mx_end_frame_idx(self) -> mx.Number:
        """Begin frame idx."""
        return self._mx_end_frame_idx
        
    @property
    def mx_playing(self) -> mx.Flag:
        """Flag to control play/stop"""
        return self._mx_playing
           
    @property
    def mx_frame_idx(self) -> mx.Number:
        """Current frame idx."""
        return self._mx_frame_idx
        
          
    @ax.task
    def _main_task(self):
        yield ax.attach_to(self._tg)
        
        while True:

            tl = self._tl
            pr = tl.process(req_begin_frame_idx=self._mx_begin_frame_idx.sign(self).value if not self._mx_begin_frame_idx.signed_by(self) else None,
                            req_end_frame_idx=self._mx_end_frame_idx.sign(self).value if not self._mx_end_frame_idx.signed_by(self) else None,
                            req_playing=self._mx_playing.sign(self).value if not self._mx_playing.signed_by(self) else None,
                            req_frame_idx=self._mx_frame_idx.sign(self).value if not self._mx_frame_idx.signed_by(self) else None,)
            
            if (new_begin_frame_idx := pr.new_begin_frame_idx) is not None:
                self._mx_begin_frame_idx.set(new_begin_frame_idx).sign(self)
            
            if (new_end_frame_idx := pr.new_end_frame_idx) is not None:
                self._mx_end_frame_idx.set(new_end_frame_idx).sign(self)
                
            if (new_is_playing := pr.new_is_playing) is not None:
                self._mx_playing.set(new_is_playing).sign(self)
                
            if (new_frame_idx := pr.new_frame_idx) is not None:
                self._mx_frame_idx.set(new_frame_idx).sign(self)
                
                if (task_on_frame_idx := self._task_on_frame_idx) is not None:
                    task = task_on_frame_idx(new_frame_idx)
                    yield ax.wait(task)
                
                
            
            
            yield ax.sleep(1.0 / 240)
    
# if self._frame_idx_req:
#     self._frame_idx_req = False
#     req_frame_idx = self._mx_frame_idx.value
# else:
#     req_frame_idx = None
#self._frame_idx_req = False





# from datetime import datetime
# from typing import Generator, Iterable, List, Sequence, Set, Union

# from xlib import ax, mx

# from .Timeline import Timeline


# class RxTimeline(mx.Disposable):
#     """```
#         Universal horizontal timeline for any purposes.
#     ```"""
        
#     def __init__(self,  frame_count : int,
#                         task_on_frame_idx : ax.Task[int] = None,
#                         ):
#         """```
            
#             task_on_frame_idx   
#         ```"""
#         super().__init__()
#         self._task_on_frame_idx = task_on_frame_idx
        
#         self._tl = Timeline(0, frame_count=frame_count)
   
#         self._mx_frame_count = mx.Number(frame_count-1, mx.Number.Config(min=frame_count-1, max=frame_count-1, read_only=True)).dispose_with(self)
#         self._mx_begin_frame_idx = mx.Number(0, mx.Number.Config(min=0, max=frame_count-1), filter=lambda n,o: (setattr(self, '_req_begin_frame_idx', n), n)[-1]).dispose_with(self)
#         self._mx_end_frame_idx = mx.Number(frame_count-1, mx.Number.Config(min=0, max=frame_count-1), filter=lambda n,o: (setattr(self, '_req_end_frame_idx', n), n)[-1]).dispose_with(self)
#         self._mx_playing = mx.Flag(False, filter=lambda n,o: (setattr(self, '_req_playing', n), n)[-1]).dispose_with(self)
#         self._mx_frame_idx = mx.Number(0, mx.Number.Config(min=0, max=frame_count-1), filter=lambda n,o: (setattr(self, '_req_frame_idx', n), n)[-1] ).dispose_with(self)
        
#         self._req_begin_frame_idx = self._mx_begin_frame_idx.value
#         self._req_end_frame_idx = self._mx_end_frame_idx.value
#         self._req_playing = self._mx_playing.value
#         self._req_frame_idx = self._mx_frame_idx.value
        
#         self._tg = ax.TaskGroup()
#         self._main_task()
        
#     def dispose(self) -> None:
#         super().dispose()
#         self._tg.dispose()
    
#     @property
#     def mx_frame_count(self) -> mx.Number:
#         """Readonly frame count."""
#         return self._mx_frame_count
        
#     @property
#     def mx_begin_frame_idx(self) -> mx.Number:
#         """Begin frame idx."""
#         return self._mx_begin_frame_idx
            
#     @property
#     def mx_end_frame_idx(self) -> mx.Number:
#         """Begin frame idx."""
#         return self._mx_end_frame_idx
           
#     @property
#     def mx_playing(self) -> mx.Flag:
#         """Flag to control play/stop"""
#         return self._mx_playing
           
#     @property
#     def mx_frame_idx(self) -> mx.Number:
#         """Current frame idx."""
#         return self._mx_frame_idx
        
#     @ax.task
#     def _main_task(self):
#         yield ax.attach_to(self._tg)
        
#         while True:
            
#             pr = self._tl.process(  req_begin_frame_idx=self._req_begin_frame_idx,
#                                     req_end_frame_idx=self._req_end_frame_idx, 
#                                     req_playing=self._req_playing,
#                                     req_frame_idx=self._req_frame_idx,) 
            
#             if (new_is_playing := pr.new_is_playing) is not None:
#                 self._mx_playing.set(new_is_playing)
                
#             if (new_frame_idx := pr.new_frame_idx) is not None:
#                 self._mx_frame_idx.set(new_frame_idx)
                
#                 if (task_on_frame_idx := self._task_on_frame_idx) is not None:
#                     task = task_on_frame_idx(new_frame_idx)
#                     yield ax.wait(task)
                
#             self._req_playing = None
#             self._req_frame_idx = None
#             self._req_begin_frame_idx = None
#             self._req_end_frame_idx = None
            
            
#             yield ax.sleep(1.0 / 240)
    
# # if self._frame_idx_req:
# #     self._frame_idx_req = False
# #     req_frame_idx = self._mx_frame_idx.value
# # else:
# #     req_frame_idx = None
# #self._frame_idx_req = False