from typing import Union
from .RxMediaSource import RxMediaSource
from xlib import qt, qx, ax, mx
import numpy as np
from RxTimeline import RxTimelineGUI

class RxMediaSourceGUI(qx.QVBoxLayout):
    def __init__(self, vp : RxMediaSource):
        super().__init__()
        self._vp = vp
        
        #qt.as_disposable(obj).dispose_with(other)
        #qt.dispose(obj : QObject)
        #qt.h_compact(lbl)
        
        canvas_source_type = self._canvas_source_type = qx.QVBoxLayout()
        
        self._canvas_root = qx.QVBoxLayout().add_widgets(self._canvas_source_type)
        
        self.add_widgets(
            qx.QHBoxLayout().add_widgets(
                qx.QLabel().set_text('Media source').h_compact(),
                qx.QComboBoxRxSingleChoice(vp.mx_source_type),
                qx.QSpacer().h_expand(),
            ).v_compact(),
            self._canvas_root,
        )
        vp.mx_source_type.reflect(self._on_vp_mx_source_type).dispose_with(canvas_source_type)
    
    def _on_vp_mx_source_type(self, source_type : RxMediaSource.SourceType):
        if source_type is RxMediaSource.SourceType.Unselected:
            
            self._canvas_source_type.dispose_childs().add_widgets(
                qx.QSpacer()
            )
        else:
            canvas_error = self._canvas_error = qx.QVBoxLayout()
            
            self._canvas_source_type.dispose_childs().add_widgets(
                qx.QMxPathState(self._vp.mx_media_pathdlg),
                canvas_error,
            )
            
            self._vp.mx_error.reflect(self._ref_vp_mx_error).dispose_with(canvas_error)
            
            
    def _ref_vp_mx_error(self, error : Union[str, None]):
        if error is not None:
            self._canvas_error.dispose_childs().add_widgets(
                    (qx.QLabel()                
                        .set_text(f'Error: {error}')
                        .set_text_interaction_flags(qx.QLabel.TextInteractionFlag.TextSelectableByMouse)
                        .set_word_wrap(True).set_font(qx.QFont.from_db(qx.EFontDB.FixedWidth))
                        .set_align(qx.Align.Center)
                    ),
                )
        else:
            canvas_media_pathdlg = self._canvas_media_pathdlg = qx.QVBoxLayout()
            self._canvas_error.dispose_childs().add_widgets(
                canvas_media_pathdlg,
            )
    
            self._vp.mx_media_pathdlg.mx_path.reflect(self._ref_vp_mx_media_path).dispose_with(canvas_media_pathdlg)

    def _ref_vp_mx_media_path(self, path):
        print('_ref_vp_mx_media_path', path)
        if path is not None:
            self._canvas_media_pathdlg.dispose_childs().add_widgets(
                qx.QPixmapWidgetRxNumpyState(self._vp.mx_frame),
                RxTimelineGUI(self._vp.mx_timeline),
            )
            
        else:
            self._canvas_media_pathdlg.dispose_childs().add_widgets(
                qx.QSpacer()     
            )  
            