import operator
import pickle
import threading
from collections import deque
from enum import Enum, auto
from pathlib import Path
from typing import Generator, Iterable, List, Sequence, Set, Union
from uuid import UUID

import cv2
import numpy as np

from interbox import ax, mx
from xlib import path as lib_path, cv as lib_cv

class ESortBy(Enum):
    source_name = auto()
    blur = auto()

class RxImageset(mx.Disposable):
    """
    
    """
    def __init__(self, path : Path):
        """```
        raises NO errors.
        If error occurs, check mx_closed and mx_error.
        ```"""
        super().__init__()
        self._path = path
        
        self._main_thread = ax.get_current_thread()
        self._sub_thread   = ax.Thread().dispose_with(self)
        self._tg          = ax.TaskGroup().dispose_with(self)
        self._tg_sort_by  = ax.TaskGroup().dispose_with(self)
        
        self._mx_image_sorted_update = mx.Event0().dispose_with(self)
        
        #self._mx_sort_by_menu = mx.Menu[ESortBy]([ e for e in ESortBy], control=self.sort_faces_by).dispose_with(self)
        
        
        
        self._images_paths = []
        self._images_ids_sorted = []
        
        self._mx_init_future = None#mx.Future( self._initialization_task() ).dispose_with(self)
        
    @property
    def mx_init_task(self): #-> IAtom[ ax.Future ] InitFuture
        """indicates Future object of initialization Task."""
    
    @ax.task
    def _initialization_task(self):
        yield ax.attach_to(self._tg)
        yield ax.switch_to(self._sub_thread)
        
        yield ax.sleep(0.5)
        if not self._path.exists():
            raise Exception(f'{self._path} not found.')
            
        for filepath in lib_path.get_files_paths(self._path, ['.jpg','.jpeg','.png']):
            ...
            #'_user_mask'
            #'_tgained_mask'
        
        self._images_paths = lib_path.get_files_paths(self._path, ['.jpg','.jpeg','.png'])
              
        #ax.Future()
    
    @property
    def mx_init_future(self): 
        """Future object of initialization Task."""
        return self._mx_init_future
            
               
    @property    
    def mx_image_sorted_update(self) -> mx.Event0: 
        """Signal emitted when sorted images has been updated"""
        return self._mx_image_sorted_update
        
    @property    
    def mx_sort_by_menu(self) -> mx.Menu[ESortBy]: return self._mx_sort_by_menu
    
    def get_image_count(self) -> int: return len(self._images_paths)
    
    def get_image_name_by_id(self, id : int) -> str:
        return self._images_paths[id].name
        
    @ax.task
    def set_image_mask(self, id : int, img):
        yield ax.attach_to(self._tg)
        
    @ax.task
    def get_image_by_id(self, id : int) -> np.ndarray:
        """"""
        yield ax.attach_to(self._tg)
        yield ax.switch_to(self._sub_thread)
        print('get_image_by_id', id)
        
        return lib_cv.imread(self._images_paths[id])
            
    #def get_image_user_mask_by_id
    #def get_image_tgained_mask_by_id
            
    @ax.task
    def get_image_by_sorted_id(self, id : int) -> Union[np.ndarray, None]:
        """"""
        yield ax.attach_to(self._tg)
        print('get_image_by_sorted_id', id, len(self._images_ids_sorted))
        id = self._images_ids_sorted[id]
        yield ax.propagate( self.get_image_by_id(id) )
        
    @ax.task
    def sort_by(self, sort_by : ESortBy):
        """"""        
        yield ax.attach_to(self._tg_sort_by, cancel_all=True)
        yield ax.attach_to(self._tg)
        yield ax.switch_to(self._main_thread)
        
        while not self._faces_write_lock.acquire(blocking=False):
            yield ax.sleep(0)
        
        try:
            # self._mx_sort_by_progress_bar.start()
            
            yield ax.switch_to(self._sub_thread)
            
            s = deque()
            for face_uuid in self._faces_uuids:
                
                face_t = self.get_face_by_uuid(face_uuid)
                yield ax.wait(face_t)
                
                if not face_t.succeeded:
                    yield ax.cancel(face_t.error)
                    
                dface = face_t.result
                if dface is None:
                    yield ax.cancel()
                    
                if sort_by == ESortBy.source_name:
                    cond = dface.source_name
                    if cond is None:
                        cond = dface.uuid.hex
                        
                    s.append( (face_uuid, cond) )
                
                #self.get_image_by_uuid(image_uuid)
             
            if sort_by == ESortBy.source_name:   
                s = sorted(s, key=operator.itemgetter(1), reverse=False)
                s = [ x[0] for x in s ]
                
            self._faces_uuids_sorted = s
            
            yield ax.switch_to(self._main_thread)
            
            self._mx_face_sorted_update.push()        
            
        except ax.TaskFinishError: 
            ...
            
        self._faces_write_lock.release()
                

            
    def __repr__(self): return self.__str__()
    def __str__(self): return f"{super().__str__()}[RxImageset]"

   
    


    # def get_all_DImage(self) -> List[DImage]:
    #     return [ self._get_DImage_by_key(key) for key in self._DImage_grp.keys() ]
        
    # def get_all_DImage_uuids(self) -> List[ uuid.UUID ]:
    #     return [ uuid.UUID(key).bytes for key in self._DImage_grp.keys() ]
        


    # def get_DImage_by_uuid(self, uuid : bytes) -> Union[DImage, None]:
    #     return self._get_DImage_by_key(uuid.hex())

    # def delete_DImage_by_uuid(self, uuid : bytes):
    #     key = uuid.hex()
    #     if key in self._DImage_grp:
    #         del self._DImage_grp[key]
    #     if key in self._DImage_image_data_grp:
    #         del self._DImage_image_data_grp[key]

    # def iter_DImage(self, include_key=False) -> Generator[DImage, None, None]:
    #     """
    #     returns Generator of DImage
    #     """
    #     for key in self._DImage_grp.keys():
    #         uimg = self._get_DImage_by_key(key, check_key=False)
    #         yield (uimg, key) if include_key else uimg

    # def delete_all_DImage(self):
    #     """
    #     deletes all DImage from DB
    #     """
    #     for key in self._DImage_grp.keys():
    #         del self._DImage_grp[key]
    #     for key in self._DImage_image_data_grp.keys():
    #         del self._DImage_image_data_grp[key]


   
    # def delete_DFace_by_uuid(self, uuid : bytes) -> bool:
    #     key = uuid.hex()
    #     if key in self._DFace_grp:
    #         del self._DFace_grp[key]
    #         return True
    #     return False
    
           
    # def iter_DFace(self) -> Generator[DFace, None, None]:
    #     """
    #     returns Generator of DFace
    #     """
    #     for key in self._DFace_grp.keys():
    #         yield DFace.from_state(pickle.loads(self._locked_group_read_bytes(self._DFace_grp, key, check_key=False)))

    # def delete_all_DFace(self):
    #     """
    #     deletes all DFace from DB
    #     """
    #     for key in self._DFace_grp.keys():
    #         del self._DFace_grp[key]

    # ###################
    # ### UPerson
    # ###################

    # def add_UPerson(self, uperson_or_list : UPerson, update_existing=True):
    #     """
    #     add or update UPerson in DB
    #     """
    #     if not isinstance(uperson_or_list, Iterable):
    #         uperson_or_list : List[UPerson] = [uperson_or_list]

    #     for uperson in uperson_or_list:
    #         self._locked_group_write_bytes(self._UPerson_grp, uperson.get_uuid().hex(), pickle.dumps(uperson.dump_state()), update_existing=update_existing )

    # def get_UPerson_count(self) -> int:
    #     return len(self._UPerson_grp.keys())

    # def get_all_UPerson(self) -> List[UPerson]:
    #     return [ UPerson.from_state(pickle.loads(self._locked_group_read_bytes(self._UPerson_grp, key, check_key=False))) for key in self._UPerson_grp.keys() ]
    
    # def get_all_UPerson_uuids(self) -> List[bytes]:
    #     return [ uuid.UUID(key).bytes for key in self._UPerson_grp.keys() ]
    
    # def get_UPerson_by_uuid(self, uuid : bytes) -> Union[UPerson, None]:
    #     data = self._locked_group_read_bytes(self._UPerson_grp, uuid.hex())
    #     if data is None:
    #         return None
    #     return UPerson.from_state(pickle.loads(data))

    # def delete_UPerson_by_uuid(self, uuid : bytes) -> bool:
    #     key = uuid.hex()
    #     if key in self._UPerson_grp:
    #         del self._UPerson_grp[key]
    #         return True
    #     return False

    # def iter_UPerson(self) -> Generator[UPerson, None, None]:
    #     """
    #     returns Generator of UPerson
    #     """
    #     for key in self._UPerson_grp.keys():
    #         yield UPerson.from_state(pickle.loads(self._locked_group_read_bytes(self._UPerson_grp, key, check_key=False)))

    # def delete_all_UPerson(self):
    #     """
    #     deletes all UPerson from DB
    #     """
    #     for key in self._UPerson_grp.keys():
    #         del self._UPerson_grp[key]

    

    # def optimize(self, verbose=True):
    #     """
    #     recreate Dataset with optimized structure.
    #     """
    #     if verbose:
    #         print(f'Optimizing {self._path.name}...')

    #     tmp_path = self._path.parent / (self._path.stem + '_optimizing' + self._path.suffix)

    #     tmp_fs = Dataset(tmp_path, write_access=True, recreate=True)
    #     self._locked_group_copy(tmp_fs._DFace_grp, self._DFace_grp, verbose=verbose)
    #     self._locked_group_copy(tmp_fs._UPerson_grp, self._UPerson_grp, verbose=verbose)
    #     self._locked_group_copy(tmp_fs._DImage_grp, self._DImage_grp, verbose=verbose)
    #     self._locked_group_copy(tmp_fs._DImage_image_data_grp, self._DImage_image_data_grp, verbose=verbose)
    #     tmp_fs._close()

    #     self._close()
    #     self._path.unlink()
    #     tmp_path.rename(self._path)
    #     self._open()
    