from .RxDataset import RxDataset, DFace, DImage
from xlib import qt, qx, ax, mx

class RxDatasetGUI(qx.QVBoxLayout):
    def __init__(self, dataset : RxDataset):
        super().__init__()
        self._dataset = dataset
        
        self._viewer = None
        self._viewer_holder = qx.QVBoxLayout()
        
        self.add_widgets(
            qx.QHBoxLayout().add_widgets(
                qx.QLabel().set_text('RxDataset').h_compact(),
                qx.QSpacer().h_expand(),
            ).v_compact(),
            
            self._viewer_holder,
        )
        
        dataset = self._dataset
    
        viewer = self._viewer = qx.QLivePixmapView(task_get_item_info=self._on_viewer_get_item_info)
        viewer.set_font(qx.QFont.from_db(qx.EFontDB.FixedWidth))
        
        item_size_slider = qx.QSlider().set_minimum(1).set_maximum(20).set_value(1)
        item_size_slider.mx_value.reflect(lambda value: viewer.set_item_size(32*value,32*value))
        
        load_menu = (qx.QMenuRxMenu(dataset.mx_sort_by_menu)
                #.set_parent(gui_wnd)
                .set_font(qx.QFont.from_db(qx.EFontDB.FixedWidth, qx.ESize.M))
                #.hide()
            ).dispose_with(viewer)
            
        self._viewer_holder.add_widgets(
            qx.QHBoxLayout().add_widgets(
                qx.QLabel().set_text('Item size').h_compact(),
                item_size_slider,
                
                (qx.QPushButton()   .set_text('Sort By...')
                                    .inline(lambda btn: btn.mx_clicked.listen(lambda: load_menu.show()).dispose_with(btn)  )
                                    .h_compact() ),     
            ).v_compact(),
            viewer,
        )

        
        dataset.mx_face_sorted_update.listen(self._on_dataset_mx_face_sorted_update).dispose_with(viewer)
        dataset.mx_face_count.reflect(self._on_dataset_mx_face_count).dispose_with(viewer)
        
        dataset.mx_closed.reflect(self._on_dataset_mx_closed).dispose_with(self._viewer_holder)
        
        #dataset.mx_face_count.value
        #dataset.mx_image_count.listen(self._on_dataset_mx_image_count).repeat_last().dispose_with(viewer)
        # dataset = self._dataset
        # dataset.mx_closed.listen(self._on_dataset_mx_closed).repeat_last()
        # if not dataset.mx_closed.value:
        #     ...
        #dataset.mx_face_added.listen(self._on_dataset_mx_face_added)
        # self._mx_sort_by = mx.SingleChoice('By name', ['By name'])
        # self._mx_sort_by.listen(self._task_sort_by).repeat_last()
        
    
    def _on_dataset_mx_closed(self, closed):
        if closed:        
            self._viewer_holder.dispose_childs()
            
            self._viewer_holder.add_widgets(
                qx.QHBoxLayout().add_widgets(
                    (qx.QLabel()
                        .set_text(f'Closed.\nError: {str(self._dataset.mx_error.value)}')
                        .set_text_interaction_flags(qx.QLabel.TextInteractionFlag.TextSelectableByMouse)
                        .set_word_wrap(True).set_font(qx.QFont.from_db(qx.EFontDB.FixedWidth))
                        .set_align(qx.Align.Center)
                    ),
                ),
            )
        
    def _on_dataset_mx_face_sorted_update(self):
        print('_on_dataset_mx_face_sorted_update')
        self._viewer.clear_cache()
    
    def _on_dataset_mx_face_count(self, count : int):
        print('_on_dataset_mx_face_count', count)
        self._viewer.set_idx_count(count)
  
        
    def _on_viewer_mx_selected_items(self, new_selected_items : set, _):
        len(new_selected_items)
        
    @ax.task
    def _on_viewer_get_item_info(self, item_id : int) -> qx.QLivePixmapView.PixmapInfo:
        #yield ax.sleep(1.0)
        
        #self._dataset.get_DImage()
        
        import numpy as np
        img = (np.indices( (32,16,1) ).sum(axis=0) % 2).astype(np.float32)
        
        item_info = qx.QLivePixmapView.PixmapInfo()
        
        item_info.caption = f'item {item_id}'
        item_info.pixmap = qt.QPixmap_from_np(img*0.3)
        
        task = self._dataset.get_face_by_sorted_id(item_id)
        yield ax.wait(task)
        
        if task.succeeded:
            dface = task.result
            if dface is not None:
                
                caption = dface.source_name
                if caption is None:
                    caption = f'item {dface.uuid}'
                item_info.caption = caption
        else:
            ...
        
       
       
        
        return item_info
    
        
      
        
    #     try:
    #         yield ax.switch_to(self._sub_thread)
            
    #         dataset = self._dataset
            
    #         # Get all DFace and perform sort by its image name
    #         d_faces_task = dataset.get_faces()
    #         yield ax.wait(d_faces_task)
            
    #         if d_faces_task.succeeded:
    #             d_faces = d_faces_task.result
    #             print('d_faces', d_faces)
                
                
    #     except ax.TaskFinishError:
    #         ...
            
    #     """
    #     face= self._faces_uuid.popLeft()
        
    #     # self._dispose_viewer()
        
    #     # self._init_viewer()
        
    #     sorted_faces = []
        
    #     DFaceSortByName(face)
    #     bisect.left
        
    #     self._faces_uuid = sorted_faces
    #     """
        
         
    # def _on_viewer_mx_sort_by(self, sort_by, _):
    #     ...
    #     # Sort By was changed
    #     # Remove viewer
    #     # Retrieve all faces from dataset        
    #     # do sort in task with progress bar
    #     # Install viewer
        
    # def _on_dataset_mx_path(self, new_path, path):
    #     self._viewer_holder.dispose_childs()
    #     self._viewer = None
        
    #     if new_path is not None:
    #         dataset = self._dataset
    #         dataset.mx_initialized_state.(self._dataset_mx_initialized_state)
    #         """
    #         dataset.mx_DFace_count.
    #         dataset.
            
    #         """
    #         viewer = self._viewer = qx.QLivePixmapView(task_get_item_info=self._on_viewer_get_item_info)
    #         viewer.set_font(qx.QFont.from_db(qx.EFontDB.FixedWidth))
    #         viewer.set_item_count(60)
    #         #viewer.mx_items_selected.listen().dispose_with(viewer)
    #         #viewer.get_selected_items()
                        
    #         
    # @ax.task
    # def _initialization_task(self) -> ax.Task:
        
    #     dataset = self._dataset
        
    #     #qx.QComboBoxRxComboState

    #     print('self._faces_uuid',self._faces_uuid)
        
    #     yield ax.switch_to(self._main_thread)
        
    #     self._init_viewer()    
#QScrollBar()

# class XPictureItem:
#     def __init__(self, image : qx.Image = None):
#         self._image = image

# class XPictureListWidget(qx.Widget):
#     def __init__(self,  on_get_item_data : Callable,
#                         name : Union[str, None] = None,  
#                         parent = None):
#         super().__init__(name=name, parent=parent)
        
#         self._on_get_item_data = on_get_item_data
        
#         self._count = 0
        
#         self.__item_size = 128
        
#         self.__items = []
    
#     def clear(self):
#         ...
        
#     def set_item_count(self, count : int):
#         if self._count != count:
#             self._count = count
            
        
#     def add_item(self, img : qx.Image, text : str = None):
#         ...
        
#     def get_selected_items(self):
#         ...
    
        
#     def get_q_widget(self): return self.__q_widget
        
#     def _on_attach(self):
#         super()._on_attach()
#         list_view.setViewMode(QListView.ViewMode.IconMode)
#         list_view.setIconSize(QSize(200,200))
#         list_view.setResizeMode(QListView.ResizeMode.Adjust)
#         list_view.setMovement(QListView.Movement.Static)
        
#         list_view.setSelectionMode(QListView.SelectionMode.ExtendedSelection)
#         list_view.setSelectionRectVisible(True)
        
#         qt.set(list_view, on_itemSelectionChanged=lambda: print('qwe'))
        
#         q = QListWidgetItem('asdasdasdasdasdasdasdasdasdasdasd')
        
#         list_view.addItem(q)
        
#         for _ in range(1000):
#             list_view.addItem(QListWidgetItem('asdasdasdasdasda\nsdasdasdasdasdasd'))
#         # self._update_font()
        
#     def _on_detach(self):
#         super()._on_detach()
#         self.__q_widget.hide()
#         self.__q_widget.setParent(None)
#         self.__q_widget.deleteLater()    
        