import uuid as lib_uuid
from typing import Union

import numpy as np




class DImage:
    """
    Describes Dataset record of uncompressed image uint8/float32 HWC ( 1/3/4 channels )
    
        np_image must be uint8/float32 and HW/HWC 1/3/4 channels.
    """

    def __init__(self):
        self._uuid : lib_uuid.UUID = None
        self._name : Union[str, None] = None
        self._np_image : Union[np.ndarray, None] = None
        
    @property
    def uuid(self) -> lib_uuid.UUID:
        if self._uuid is None:
            self._uuid = lib_uuid.uuid4()
        return self._uuid
    @uuid.setter
    def uuid(self, value): self._uuid = value
        
    @property
    def name(self) -> Union[str, None]: return self._name
    @name.setter
    def name(self, value): self._name = value
        
    @property
    def np_image(self) -> Union[np.ndarray, None]: return self._np_image
    @np_image.setter
    def np_image(self, np_image): 
        if np_image is not None:
            if np_image.ndim == 2:
                np_image = np_image[...,None]
            if np_image.ndim != 3:
                raise ValueError('np_image must have ndim 2 or 3')
            if np_image.shape[-1] not in [1,3,4]:
                raise ValueError('np_image channels must be 1,3,4')
            if np_image.dtype not in [np.uint8, np.float32]:
                raise ValueError('np_image dtype must be uint8/float32')
            
        self._np_image = np_image    
        
    def __str__(self): return f"DImage UUID:[...{self.get_uuid()[-4:].hex()}] name:[{self._name}] image:[{ (self._np_image.shape, self._np_image.dtype) if self._np_image is not None else None}]"
    def __repr__(self): return self.__str__()
        

    

