from typing import Union
from uuid import UUID, uuid4

# from .ELandmarks2D import ELandmarks2D
# from .EMaskType import EMaskType
# from .FLandmarks2D import FLandmarks2D
# from .FPose import FPose
# from .FRect import FRect
# from .State import State


class DFace:
    def __init__(self):
        """
        Describes single face
        """
        self._uuid : UUID = uuid4()
        self._image_uuid : UUID = None
        self._source_name : str = None

    @property
    def uuid(self) -> UUID:
        return self._uuid
    @uuid.setter
    def uuid(self, value): self._uuid = value
    
    @property
    def image_uuid(self) -> Union[UUID, None]:
        return self._image_uuid
    @image_uuid.setter
    def image_uuid(self, value): self._image_uuid = value

    @property
    def source_name(self) -> Union[str, None]:
        """Source name from which the Face was created, for example photo.jpg movie.mp4_0000001"""
        return self._source_name
    @source_name.setter
    def source_name(self, value): self._source_name = value


    def __repr__(self): return self.__str__()
    def __str__(self): return f"DFace UUID:[...{self._uuid.hex}]"
    
    
    

    # def get_UImage_uuid(self) -> Union[bytes, None]: return self._UImage_uuid
    # def set_UImage_uuid(self, UImage_uuid : Union[bytes, None]):
    #     if UImage_uuid is not None and not isinstance(UImage_uuid, bytes):
    #         raise ValueError(f'UImage_uuid must be an instance of bytes or None')
    #     self._UImage_uuid = UImage_uuid

    # def get_UPerson_uuid(self) -> Union[bytes, None]: return self._UPerson_uuid
    # def set_UPerson_uuid(self, UPerson_uuid : Union[bytes, None]):
    #     if UPerson_uuid is not None and not isinstance(UPerson_uuid, bytes):
    #         raise ValueError(f'UPerson_uuid must be an instance of bytes or None')
    #     self._UPerson_uuid = UPerson_uuid

    # def get_FRect(self) -> Union['FRect', None]: return self._FRect
    # def set_FRect(self, face_urect : Union['FRect', None]):
    #     if face_urect is not None and not isinstance(face_urect, FRect):
    #         raise ValueError(f'face_urect must be an instance of FRect or None')
    #     self._FRect = face_urect

    # def get_all_FLandmarks2D(self) -> List[FLandmarks2D]: return self._FLandmarks2D_list
    
    # def get_FLandmarks2D_best(self) -> Union[FLandmarks2D, None]:
    #     """get best available FLandmarks2D """
    #     lmrks = self.get_FLandmarks2D_by_type(ELandmarks2D.L468)
    #     if lmrks is None:
    #         lmrks = self.get_FLandmarks2D_by_type(ELandmarks2D.L68)
    #     if lmrks is None:
    #         lmrks = self.get_FLandmarks2D_by_type(ELandmarks2D.L5)
    #     return lmrks
        
    # def get_FLandmarks2D_by_type(self, type : ELandmarks2D) -> Union[FLandmarks2D, None]:
    #     """get FLandmarks2D from list by type"""
    #     if not isinstance(type, ELandmarks2D):
    #         raise ValueError(f'type must be an instance of ELandmarks2D')

    #     for ulmrks in self._FLandmarks2D_list:
    #         if ulmrks.get_type() == type:
    #             return ulmrks
    #     return None

    # def add_FLandmarks2D(self, flmrks : FLandmarks2D):
    #     if not isinstance(flmrks, FLandmarks2D):
    #         raise ValueError('flmrks must be an instance of FLandmarks2D')

    #     if self.get_FLandmarks2D_by_type(flmrks.get_type()) is not None:
    #         raise Exception(f'_FLandmarks2D_list already contains type {flmrks.get_type()}.')

    #     self._FLandmarks2D_list.append(flmrks)

    # def get_FPose(self) -> Union[FPose, None]: return self._FPose
    # def set_FPose(self, face_pose : FPose):
    #     if not isinstance(face_pose, FPose):
    #         raise ValueError('face_pose must be an instance of FPose')
    #     self._FPose = face_pose

    # def get_mask_info_list(self) -> List[Tuple[EMaskType, bytes, Affine2DMat]]:
    #     return self._mask_info_list

    # def add_mask_info(self, mask_type : EMaskType, UImage_uuid : bytes, mask_to_mark_uni_mat : Affine2DMat):
    #     if not isinstance(mask_type, EMaskType):
    #         raise ValueError('mask_type must be an instance of EMaskType')
    #     if not isinstance(UImage_uuid, bytes):
    #         raise ValueError('UImage_uuid must be an instance of bytes')
    #     if not isinstance(mask_to_mark_uni_mat, Affine2DMat):
    #         raise ValueError('mask_to_mark_uni_mat must be an instance of Affine2DMat')

    #     self._mask_info_list.append( (mask_type, UImage_uuid, mask_to_mark_uni_mat) )
