/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import android.icu.text.DateTimePatternGenerator;
import android.icu.util.ULocale;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.Locale;
import libcore.icu.ICU;
import libcore.icu.LocaleData;

public class ICU_Delegate {
    @LayoutlibDelegate
    static String getBestDateTimePatternNative(String skeleton, String localeName) {
        return DateTimePatternGenerator.getInstance(new ULocale(localeName)).getBestPattern(skeleton);
    }

    @LayoutlibDelegate
    static String[] getAvailableLocalesNative() {
        return new String[0];
    }

    @LayoutlibDelegate
    static String getCurrencyCode(String locale) {
        return "";
    }

    @LayoutlibDelegate
    static String getISO3Country(String locale) {
        return "";
    }

    @LayoutlibDelegate
    static String getISO3Language(String locale) {
        return "";
    }

    @LayoutlibDelegate
    static String getScript(String locale) {
        return "";
    }

    @LayoutlibDelegate
    static String[] getISOLanguagesNative() {
        return Locale.getISOLanguages();
    }

    @LayoutlibDelegate
    static String[] getISOCountriesNative() {
        return Locale.getISOCountries();
    }

    @LayoutlibDelegate
    static boolean initLocaleDataNative(String locale, LocaleData result) {
        result.firstDayOfWeek = 1;
        result.minimalDaysInFirstWeek = 1;
        result.amPm = new String[]{"AM", "PM"};
        result.eras = new String[]{"BC", "AD"};
        result.longMonthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        result.shortMonthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        result.longStandAloneMonthNames = result.longMonthNames;
        result.shortStandAloneMonthNames = result.shortMonthNames;
        result.longWeekdayNames = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        result.shortWeekdayNames = new String[]{"", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        result.tinyWeekdayNames = new String[]{"", "S", "M", "T", "W", "T", "F", "S"};
        result.longStandAloneWeekdayNames = result.longWeekdayNames;
        result.shortStandAloneWeekdayNames = result.shortWeekdayNames;
        result.tinyStandAloneWeekdayNames = result.tinyWeekdayNames;
        result.fullTimeFormat = "";
        result.longTimeFormat = "";
        result.mediumTimeFormat = "";
        result.shortTimeFormat = "";
        result.fullDateFormat = "";
        result.longDateFormat = "";
        result.mediumDateFormat = "";
        result.shortDateFormat = "";
        result.zeroDigit = (char)48;
        result.decimalSeparator = (char)46;
        result.groupingSeparator = (char)44;
        result.patternSeparator = (char)32;
        result.percent = "%";
        result.perMill = "\u2030";
        result.monetarySeparator = (char)32;
        result.minusSign = "-";
        result.exponentSeparator = "e";
        result.infinity = "\u221e";
        result.NaN = "NaN";
        result.currencySymbol = "$";
        result.internationalCurrencySymbol = "USD";
        result.numberPattern = "%f";
        result.integerPattern = "%d";
        result.currencyPattern = "%s";
        result.percentPattern = "%f";
        return true;
    }

    @LayoutlibDelegate
    static void setDefaultLocale(String locale) {
        ICU.setDefaultLocale(locale);
    }

    @LayoutlibDelegate
    static String getDefaultLocale() {
        return ICU.getDefaultLocale();
    }
}

