/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.compat.annotation.UnsupportedAppUsage;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.system.StructStat;
import com.android.tools.layoutlib.java.System_Delegate;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import libcore.io.ClassPathURLStreamHandler;
import libcore.io.IoUtils;
import libcore.io.Libcore;

public class DexPathList {
    private static final String DEX_SUFFIX = ".dex";
    private static final String zipSeparator = "!/";
    @UnsupportedAppUsage
    private final ClassLoader definingContext;
    @UnsupportedAppUsage
    private Element[] dexElements;
    @UnsupportedAppUsage
    NativeLibraryElement[] nativeLibraryPathElements;
    @UnsupportedAppUsage
    private final List<File> nativeLibraryDirectories;
    @UnsupportedAppUsage
    private final List<File> systemNativeLibraryDirectories;
    @UnsupportedAppUsage
    private IOException[] dexElementsSuppressedExceptions;

    private List<File> getAllNativeLibraryDirectories() {
        ArrayList<File> allNativeLibraryDirectories = new ArrayList<File>(this.nativeLibraryDirectories);
        allNativeLibraryDirectories.addAll(this.systemNativeLibraryDirectories);
        return allNativeLibraryDirectories;
    }

    public DexPathList(ClassLoader definingContext, String librarySearchPath) {
        if (definingContext == null) {
            throw new NullPointerException("definingContext == null");
        }
        this.definingContext = definingContext;
        this.nativeLibraryDirectories = DexPathList.splitPaths(librarySearchPath, false);
        this.systemNativeLibraryDirectories = DexPathList.splitPaths(System.getProperty("java.library.path"), true);
        this.nativeLibraryPathElements = DexPathList.makePathElements(this.getAllNativeLibraryDirectories());
    }

    @UnsupportedAppUsage
    public DexPathList(ClassLoader definingContext, String dexPath, String librarySearchPath, File optimizedDirectory) {
        this(definingContext, dexPath, librarySearchPath, optimizedDirectory, false);
    }

    DexPathList(ClassLoader definingContext, String dexPath, String librarySearchPath, File optimizedDirectory, boolean isTrusted) {
        if (definingContext == null) {
            throw new NullPointerException("definingContext == null");
        }
        if (dexPath == null) {
            throw new NullPointerException("dexPath == null");
        }
        if (optimizedDirectory != null) {
            if (!optimizedDirectory.exists()) {
                throw new IllegalArgumentException("optimizedDirectory doesn't exist: " + optimizedDirectory);
            }
            if (!optimizedDirectory.canRead() || !optimizedDirectory.canWrite()) {
                throw new IllegalArgumentException("optimizedDirectory not readable/writable: " + optimizedDirectory);
            }
        }
        this.definingContext = definingContext;
        ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
        this.dexElements = DexPathList.makeDexElements(DexPathList.splitDexPath(dexPath), optimizedDirectory, suppressedExceptions, definingContext, isTrusted);
        this.nativeLibraryDirectories = DexPathList.splitPaths(librarySearchPath, false);
        this.systemNativeLibraryDirectories = DexPathList.splitPaths(System.getProperty("java.library.path"), true);
        this.nativeLibraryPathElements = DexPathList.makePathElements(this.getAllNativeLibraryDirectories());
        this.dexElementsSuppressedExceptions = suppressedExceptions.size() > 0 ? suppressedExceptions.toArray(new IOException[suppressedExceptions.size()]) : null;
    }

    public String toString() {
        return "DexPathList[" + Arrays.toString(this.dexElements) + ",nativeLibraryDirectories=" + Arrays.toString(this.getAllNativeLibraryDirectories().toArray()) + "]";
    }

    public List<File> getNativeLibraryDirectories() {
        return this.nativeLibraryDirectories;
    }

    @UnsupportedAppUsage
    public void addDexPath(String dexPath, File optimizedDirectory) {
        this.addDexPath(dexPath, optimizedDirectory, false);
    }

    public void addDexPath(String dexPath, File optimizedDirectory, boolean isTrusted) {
        ArrayList<IOException> suppressedExceptionList = new ArrayList<IOException>();
        Element[] newElements = DexPathList.makeDexElements(DexPathList.splitDexPath(dexPath), optimizedDirectory, suppressedExceptionList, this.definingContext, isTrusted);
        if (newElements != null && newElements.length > 0) {
            this.dexElements = DexPathList.concat(Element.class, this.dexElements, newElements);
        }
        if (suppressedExceptionList.size() > 0) {
            IOException[] newSuppExceptions = suppressedExceptionList.toArray(new IOException[suppressedExceptionList.size()]);
            this.dexElementsSuppressedExceptions = this.dexElementsSuppressedExceptions != null ? DexPathList.concat(IOException.class, this.dexElementsSuppressedExceptions, newSuppExceptions) : newSuppExceptions;
        }
    }

    private static <T> T[] concat(Class<T> componentType, T[] inputA, T[] inputB) {
        Object[] output = (Object[])Array.newInstance(componentType, inputA.length + inputB.length);
        System.arraycopy(inputA, 0, output, 0, inputA.length);
        System.arraycopy(inputB, 0, output, inputA.length, inputB.length);
        return output;
    }

    void initByteBufferDexPath(ByteBuffer[] dexFiles) {
        if (dexFiles == null) {
            throw new NullPointerException("dexFiles == null");
        }
        if (Arrays.stream(dexFiles).anyMatch(v -> v == null)) {
            throw new NullPointerException("dexFiles contains a null Buffer!");
        }
        if (this.dexElements != null || this.dexElementsSuppressedExceptions != null) {
            throw new IllegalStateException("Should only be called once");
        }
        ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
        try {
            Element[] null_elements = null;
            DexFile dex = new DexFile(dexFiles, this.definingContext, null_elements);
            String classLoaderContext = dex.isBackedByOatFile() ? null : DexFile.getClassLoaderContext(this.definingContext, null_elements);
            this.dexElements = new Element[]{new Element(dex)};
            if (classLoaderContext != null) {
                dex.verifyInBackground(this.definingContext, classLoaderContext);
            }
        }
        catch (IOException suppressed) {
            System_Delegate.log("Unable to load dex files", suppressed);
            suppressedExceptions.add(suppressed);
            this.dexElements = new Element[0];
        }
        if (suppressedExceptions.size() > 0) {
            this.dexElementsSuppressedExceptions = suppressedExceptions.toArray(new IOException[suppressedExceptions.size()]);
        }
    }

    private static List<File> splitDexPath(String path) {
        return DexPathList.splitPaths(path, false);
    }

    @UnsupportedAppUsage
    private static List<File> splitPaths(String searchPath, boolean directoriesOnly) {
        ArrayList<File> result = new ArrayList<File>();
        if (searchPath != null) {
            for (String path : searchPath.split(File.pathSeparator)) {
                if (directoriesOnly) {
                    try {
                        StructStat sb = Libcore.os.stat(path);
                        if (!OsConstants.S_ISDIR(sb.st_mode)) {
                        }
                    }
                    catch (ErrnoException ignored) {}
                    continue;
                }
                result.add(new File(path));
            }
        }
        return result;
    }

    @UnsupportedAppUsage
    public static Element[] makeInMemoryDexElements(ByteBuffer[] dexFiles, List<IOException> suppressedExceptions) {
        Element[] elements = new Element[dexFiles.length];
        int elementPos = 0;
        for (ByteBuffer buf : dexFiles) {
            try {
                DexFile dex = new DexFile(new ByteBuffer[]{buf}, null, null);
                elements[elementPos++] = new Element(dex);
            }
            catch (IOException suppressed) {
                System_Delegate.log("Unable to load dex file: " + buf, suppressed);
                suppressedExceptions.add(suppressed);
            }
        }
        if (elementPos != elements.length) {
            elements = Arrays.copyOf(elements, elementPos);
        }
        return elements;
    }

    @UnsupportedAppUsage
    private static Element[] makeDexElements(List<File> files, File optimizedDirectory, List<IOException> suppressedExceptions, ClassLoader loader) {
        return DexPathList.makeDexElements(files, optimizedDirectory, suppressedExceptions, loader, false);
    }

    private static Element[] makeDexElements(List<File> files, File optimizedDirectory, List<IOException> suppressedExceptions, ClassLoader loader, boolean isTrusted) {
        Element[] elements = new Element[files.size()];
        int elementsPos = 0;
        for (File file : files) {
            if (file.isDirectory()) {
                elements[elementsPos++] = new Element(file);
                continue;
            }
            if (file.isFile()) {
                String name = file.getName();
                DexFile dex = null;
                if (name.endsWith(DEX_SUFFIX)) {
                    try {
                        dex = DexPathList.loadDexFile(file, optimizedDirectory, loader, elements);
                        if (dex != null) {
                            elements[elementsPos++] = new Element(dex, null);
                        }
                    }
                    catch (IOException suppressed) {
                        System_Delegate.log("Unable to load dex file: " + file, suppressed);
                        suppressedExceptions.add(suppressed);
                    }
                } else {
                    try {
                        dex = DexPathList.loadDexFile(file, optimizedDirectory, loader, elements);
                    }
                    catch (IOException suppressed) {
                        suppressedExceptions.add(suppressed);
                    }
                    elements[elementsPos++] = dex == null ? new Element(file) : new Element(dex, file);
                }
                if (dex == null || !isTrusted) continue;
                dex.setTrusted();
                continue;
            }
            System_Delegate.log("ClassLoader referenced unknown path: " + file);
        }
        if (elementsPos != elements.length) {
            elements = Arrays.copyOf(elements, elementsPos);
        }
        return elements;
    }

    @UnsupportedAppUsage
    private static DexFile loadDexFile(File file, File optimizedDirectory, ClassLoader loader, Element[] elements) throws IOException {
        if (optimizedDirectory == null) {
            return new DexFile(file, loader, elements);
        }
        String optimizedPath = DexPathList.optimizedPathFor(file, optimizedDirectory);
        return DexFile.loadDex(file.getPath(), optimizedPath, 0, loader, elements);
    }

    private static String optimizedPathFor(File path, File optimizedDirectory) {
        String fileName = path.getName();
        if (!fileName.endsWith(DEX_SUFFIX)) {
            int lastDot = fileName.lastIndexOf(".");
            if (lastDot < 0) {
                fileName = fileName + DEX_SUFFIX;
            } else {
                StringBuilder sb = new StringBuilder(lastDot + 4);
                sb.append(fileName, 0, lastDot);
                sb.append(DEX_SUFFIX);
                fileName = sb.toString();
            }
        }
        File result = new File(optimizedDirectory, fileName);
        return result.getPath();
    }

    @UnsupportedAppUsage
    private static Element[] makePathElements(List<File> files, File optimizedDirectory, List<IOException> suppressedExceptions) {
        return DexPathList.makeDexElements(files, optimizedDirectory, suppressedExceptions, null);
    }

    @UnsupportedAppUsage
    private static NativeLibraryElement[] makePathElements(List<File> files) {
        NativeLibraryElement[] elements = new NativeLibraryElement[files.size()];
        int elementsPos = 0;
        for (File file : files) {
            String path = file.getPath();
            if (path.contains(zipSeparator)) {
                String[] split = path.split(zipSeparator, 2);
                File zip = new File(split[0]);
                String dir = split[1];
                elements[elementsPos++] = new NativeLibraryElement(zip, dir);
                continue;
            }
            if (!file.isDirectory()) continue;
            elements[elementsPos++] = new NativeLibraryElement(file);
        }
        if (elementsPos != elements.length) {
            elements = Arrays.copyOf(elements, elementsPos);
        }
        return elements;
    }

    public Class<?> findClass(String name, List<Throwable> suppressed) {
        for (Element element : this.dexElements) {
            Class<?> clazz = element.findClass(name, this.definingContext, suppressed);
            if (clazz == null) continue;
            return clazz;
        }
        if (this.dexElementsSuppressedExceptions != null) {
            suppressed.addAll(Arrays.asList(this.dexElementsSuppressedExceptions));
        }
        return null;
    }

    public URL findResource(String name) {
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public Enumeration<URL> findResources(String name) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            result.add(url);
        }
        return Collections.enumeration(result);
    }

    public String findLibrary(String libraryName) {
        String fileName = System.mapLibraryName(libraryName);
        for (NativeLibraryElement element : this.nativeLibraryPathElements) {
            String path = element.findNativeLibrary(fileName);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    List<String> getDexPaths() {
        ArrayList<String> dexPaths = new ArrayList<String>();
        for (Element e : this.dexElements) {
            String dexPath = e.getDexPath();
            if (dexPath == null) continue;
            dexPaths.add(dexPath);
        }
        return dexPaths;
    }

    @UnsupportedAppUsage
    public void addNativePath(Collection<String> libPaths) {
        if (libPaths.isEmpty()) {
            return;
        }
        ArrayList<File> libFiles = new ArrayList<File>(libPaths.size());
        for (String path : libPaths) {
            libFiles.add(new File(path));
        }
        ArrayList<NativeLibraryElement> newPaths = new ArrayList<NativeLibraryElement>(this.nativeLibraryPathElements.length + libPaths.size());
        newPaths.addAll(Arrays.asList(this.nativeLibraryPathElements));
        for (NativeLibraryElement element : DexPathList.makePathElements(libFiles)) {
            if (newPaths.contains(element)) continue;
            newPaths.add(element);
        }
        this.nativeLibraryPathElements = newPaths.toArray(new NativeLibraryElement[newPaths.size()]);
    }

    static class NativeLibraryElement {
        @UnsupportedAppUsage
        private final File path;
        private final String zipDir;
        private ClassPathURLStreamHandler urlHandler;
        private boolean initialized;

        @UnsupportedAppUsage
        public NativeLibraryElement(File dir) {
            this.path = dir;
            this.zipDir = null;
        }

        public NativeLibraryElement(File zip, String zipDir) {
            this.path = zip;
            this.zipDir = zipDir;
            if (zipDir == null) {
                throw new IllegalArgumentException();
            }
        }

        public String toString() {
            if (this.zipDir == null) {
                return "directory \"" + this.path + "\"";
            }
            return "zip file \"" + this.path + "\"" + (!this.zipDir.isEmpty() ? ", dir \"" + this.zipDir + "\"" : "");
        }

        public synchronized void maybeInit() {
            if (this.initialized) {
                return;
            }
            if (this.zipDir == null) {
                this.initialized = true;
                return;
            }
            try {
                this.urlHandler = new ClassPathURLStreamHandler(this.path.getPath());
            }
            catch (IOException ioe) {
                System_Delegate.log("Unable to open zip file: " + this.path, ioe);
                this.urlHandler = null;
            }
            this.initialized = true;
        }

        public String findNativeLibrary(String name) {
            String entryName;
            this.maybeInit();
            if (this.zipDir == null) {
                String entryPath = new File(this.path, name).getPath();
                if (IoUtils.canOpenReadOnly(entryPath)) {
                    return entryPath;
                }
            } else if (this.urlHandler != null && this.urlHandler.isEntryStored(entryName = this.zipDir + '/' + name)) {
                return this.path.getPath() + DexPathList.zipSeparator + entryName;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NativeLibraryElement)) {
                return false;
            }
            NativeLibraryElement that = (NativeLibraryElement)o;
            return Objects.equals(this.path, that.path) && Objects.equals(this.zipDir, that.zipDir);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.zipDir);
        }
    }

    static class Element {
        @UnsupportedAppUsage
        private final File path;
        private final Boolean pathIsDirectory;
        @UnsupportedAppUsage
        private final DexFile dexFile;
        private ClassPathURLStreamHandler urlHandler;
        private boolean initialized;

        @UnsupportedAppUsage
        public Element(DexFile dexFile, File dexZipPath) {
            if (dexFile == null && dexZipPath == null) {
                throw new NullPointerException("Either dexFile or path must be non-null");
            }
            this.dexFile = dexFile;
            this.path = dexZipPath;
            this.pathIsDirectory = this.path == null ? null : Boolean.valueOf(this.path.isDirectory());
        }

        public Element(DexFile dexFile) {
            this(dexFile, null);
        }

        public Element(File path) {
            this(null, path);
        }

        @Deprecated
        @UnsupportedAppUsage
        public Element(File dir, boolean isDirectory, File zip, DexFile dexFile) {
            this(dir != null ? null : dexFile, dir != null ? dir : zip);
            System.err.println("Warning: Using deprecated Element constructor. Do not use internal APIs, this constructor will be removed in the future.");
            if (dir != null && (zip != null || dexFile != null)) {
                throw new IllegalArgumentException("Using dir and zip|dexFile no longer supported.");
            }
            if (isDirectory && (zip != null || dexFile != null)) {
                throw new IllegalArgumentException("Unsupported argument combination.");
            }
        }

        private String getDexPath() {
            if (this.path != null) {
                return this.path.isDirectory() ? null : this.path.getAbsolutePath();
            }
            if (this.dexFile != null) {
                return this.dexFile.getName();
            }
            return null;
        }

        public String toString() {
            if (this.dexFile == null) {
                return (this.pathIsDirectory != false ? "directory \"" : "zip file \"") + this.path + "\"";
            }
            if (this.path == null) {
                return "dex file \"" + this.dexFile + "\"";
            }
            return "zip file \"" + this.path + "\"";
        }

        public synchronized void maybeInit() {
            if (this.initialized) {
                return;
            }
            if (this.path == null || this.pathIsDirectory.booleanValue()) {
                this.initialized = true;
                return;
            }
            try {
                this.urlHandler = new ClassPathURLStreamHandler(this.path.getPath());
            }
            catch (IOException ioe) {
                System_Delegate.log("Unable to open zip file: " + this.path, ioe);
                this.urlHandler = null;
            }
            this.initialized = true;
        }

        public Class<?> findClass(String name, ClassLoader definingContext, List<Throwable> suppressed) {
            return this.dexFile != null ? this.dexFile.loadClassBinaryName(name, definingContext, suppressed) : null;
        }

        public URL findResource(String name) {
            File resourceFile;
            this.maybeInit();
            if (this.urlHandler != null) {
                return this.urlHandler.getEntryUrlOrNull(name);
            }
            if (this.path != null && this.path.isDirectory() && (resourceFile = new File(this.path, name)).exists()) {
                try {
                    return resourceFile.toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return null;
        }
    }
}

