/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.view.View;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResultBaseUtils;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.ClickableSpanViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.DuplicateClickableBoundsViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.DuplicateSpeakableTextViewHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.EditableContentDescViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.RedundantContentDescViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.SpeakableTextPresentViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.TextContrastViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.TouchTargetSizeViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.ClickableSpanCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.DuplicateClickableBoundsCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.DuplicateSpeakableTextCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.EditableContentDescCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.RedundantDescriptionCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.SpeakableTextPresentCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.TextContrastCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.TouchTargetSizeCheck;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class AccessibilityCheckResultUtils {
    private static final ImmutableBiMap<?, ?> VIEW_CHECK_ALIASES = ImmutableBiMap.builder().put(ClickableSpanViewCheck.class, ClickableSpanCheck.class).put(DuplicateClickableBoundsViewCheck.class, DuplicateClickableBoundsCheck.class).put(DuplicateSpeakableTextViewHierarchyCheck.class, DuplicateSpeakableTextCheck.class).put(EditableContentDescViewCheck.class, EditableContentDescCheck.class).put(RedundantContentDescViewCheck.class, RedundantDescriptionCheck.class).put(SpeakableTextPresentViewCheck.class, SpeakableTextPresentCheck.class).put(TextContrastViewCheck.class, TextContrastCheck.class).put(TouchTargetSizeViewCheck.class, TouchTargetSizeCheck.class).build();

    private AccessibilityCheckResultUtils() {
    }

    public static <T extends AccessibilityCheckResult> List<T> getResultsForCheck(Iterable<T> results, Class<? extends AccessibilityCheck> checkClass) {
        return AccessibilityCheckResultBaseUtils.getResultsForCheck(results, checkClass, VIEW_CHECK_ALIASES);
    }

    public static <T extends AccessibilityCheckResult> List<T> getResultsForType(Iterable<T> results, AccessibilityCheckResult.AccessibilityCheckResultType type) {
        return AccessibilityCheckResultBaseUtils.getResultsForType(results, type);
    }

    public static <T extends AccessibilityCheckResult> List<T> getResultsForTypes(Iterable<T> results, Set<AccessibilityCheckResult.AccessibilityCheckResultType> types) {
        return AccessibilityCheckResultBaseUtils.getResultsForTypes(results, types);
    }

    public static List<AccessibilityViewCheckResult> getResultsForView(Iterable<AccessibilityViewCheckResult> results, View view) {
        ArrayList<AccessibilityViewCheckResult> resultsForView = new ArrayList<AccessibilityViewCheckResult>();
        for (AccessibilityViewCheckResult result : results) {
            if (result.getView() != view) continue;
            resultsForView.add(result);
        }
        return resultsForView;
    }

    public static Matcher<AccessibilityCheckResult> matchesTypes(Matcher<? super AccessibilityCheckResult.AccessibilityCheckResultType> typeMatcher) {
        return AccessibilityCheckResultBaseUtils.matchesTypes(typeMatcher);
    }

    public static Matcher<AccessibilityCheckResult> matchesCheck(Class<? extends AccessibilityCheck> checkClass) {
        return AccessibilityCheckResultUtils.matchesChecks(Matchers.equalTo(checkClass));
    }

    public static Matcher<AccessibilityCheckResult> matchesChecks(Matcher<?> classMatcher) {
        return AccessibilityCheckResultBaseUtils.matchesChecks(classMatcher, VIEW_CHECK_ALIASES);
    }

    public static Matcher<AccessibilityCheckResult> matchesCheckNames(Matcher<? super String> classNameMatcher) {
        return AccessibilityCheckResultBaseUtils.matchesCheckNames(classNameMatcher, VIEW_CHECK_ALIASES);
    }

    public static Matcher<AccessibilityViewCheckResult> matchesViews(final Matcher<? super View> viewMatcher) {
        return new TypeSafeMemberMatcher<AccessibilityViewCheckResult>("View", viewMatcher){

            @Override
            public boolean matchesSafely(AccessibilityViewCheckResult result) {
                View view = result.getView();
                return view != null && viewMatcher.matches(view);
            }
        };
    }

    private static abstract class TypeSafeMemberMatcher<T>
    extends TypeSafeMatcher<T> {
        private static final String DESCRIPTION_FORMAT_STRING = "with %s: ";
        private final String memberDescription;
        private final Matcher<?> matcher;

        public TypeSafeMemberMatcher(String member, Matcher<?> matcher) {
            this.memberDescription = String.format(DESCRIPTION_FORMAT_STRING, member);
            this.matcher = matcher;
        }

        @Override
        public void describeTo(Description description) {
            description.appendText(this.memberDescription);
            this.matcher.describeTo(description);
        }
    }
}

